% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{AUC.cv.grpsurv}
\alias{AUC.cv.grpsurv}
\alias{AUC}
\title{Calculates AUC for cv.grpsurv objects}
\usage{
\method{AUC}{cv.grpsurv}(obj, ...)

AUC(obj, ...)
}
\arguments{
\item{obj}{A \code{cv.grpsurv} object. You must run \code{cv.grpsurv()} with the option \code{returnY=TRUE} in order for \code{AUC} to work.}

\item{\dots}{For S3 method compatibility.}
}
\description{
Calculates the cross-validated AUC (concordance) from a "cv.grpsurv" object.
}
\details{
The area under the curve (AUC), or equivalently, the concordance statistic
(C), is calculated according to the procedure described in van Houwelingen
and Putter (2011). The function calls \code{survival::concordancefit()}, except
cross-validated linear predictors are used to guard against overfitting.
Thus, the values returned by \code{AUC.cv.grpsurv()} will be lower than those you
would obtain with \code{concordancefit()} if you fit the full (unpenalized) model.
}
\examples{
\dontshow{set.seed(1)}
data(Lung)
X <- Lung$X
y <- Lung$y
group <- Lung$group

cvfit <- cv.grpsurv(X, y, group, returnY=TRUE)
head(AUC(cvfit))
ll <- log(cvfit$fit$lambda)
plot(ll, AUC(cvfit), xlim=rev(range(ll)), lwd=3, type='l',
     xlab=expression(log(lambda)), ylab='AUC', las=1)
}
\references{
van Houwelingen H, Putter H (2011). \emph{Dynamic Prediction in Clinical Survival Analysis}. CRC Press.
}
\seealso{
\code{\link[=cv.grpsurv]{cv.grpsurv()}}, \code{\link[survival:survival-deprecated]{survival::survConcordance()}}
}
