% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_benchAdj.R
\name{plot_benchAdj}
\alias{plot_benchAdj}
\title{Plot benchmarking adjustments}
\usage{
plot_benchAdj(
  PB_graphTable = NULL,
  SB_graphTable = NULL,
  SB_splineKnots = NULL,
  legendPos = "bottomright"
)
}
\arguments{
\item{PB_graphTable}{(optional)

Data frame (object of class "data.frame") corresponding to the \code{\link[=benchmarking]{benchmarking()}} (PB for "Proc Benchmarking"
approach) function output \code{graphTable} data frame. Specify \code{NULL} not to include the \code{\link[=benchmarking]{benchmarking()}} adjustments
in the plot.

\strong{Default value} is \code{PB_graphTable = NULL}.}

\item{SB_graphTable}{(optional)

Data frame (object of class "data.frame") corresponding to the \code{\link[=stock_benchmarking]{stock_benchmarking()}} (SB) function output
\code{graphTable} data frame. Specify \code{NULL} not to include the \code{\link[=stock_benchmarking]{stock_benchmarking()}} adjustments in the plot.

\strong{Default value} is \code{SB_graphTable = NULL}.}

\item{SB_splineKnots}{(optional)

Data frame (object of class "data.frame") corresponding to the \code{\link[=stock_benchmarking]{stock_benchmarking()}} (SB) function output
\code{splineKnots} data frame. Specify \code{NULL} not to include the \code{\link[=stock_benchmarking]{stock_benchmarking()}} cubic spline in the plot.

\strong{Default value} is \code{SB_splineKnots = NULL}.}

\item{legendPos}{(optional)

String (keyword) specifying the location of the legend in the plot. See the description of argument \code{x} in
the documentation of \code{graphics::legend()} for the list of valid keywords. Specify \code{NULL} not to include a
legend in the plot.

\strong{Default value} is \code{legendPos = "bottomright"}.}
}
\value{
This function returns nothing (\code{invisible(NULL)}).
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/plot_benchAdj.html}})}

Plot benchmarking adjustments for a single series in the current (active) graphics device. Up to three types of
adjustments can be overlayed in the same plot:
\itemize{
\item Adjustments generated by function \code{\link[=benchmarking]{benchmarking()}}
\item Adjustments generated by function \code{\link[=stock_benchmarking]{stock_benchmarking()}}
\item Cubic spline associated to adjustments generated by function \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}

These plots can be useful to assess the quality of the benchmarking results and compare the adjustments
generated by both benchmarking functions (\code{\link[=benchmarking]{benchmarking()}} and \code{\link[=stock_benchmarking]{stock_benchmarking()}}) for stock series.
}
\details{
\code{graphTable} data frame (arguments \code{PB_graphTable} and \code{SB_graphTable}) variables used in the plot:
\itemize{
\item \code{t} for the x-axis values (\emph{t})
\item \code{benchmarkedSubAnnualRatio} for the \emph{Stock Bench. (SB)} and \emph{Proc Bench. (PB)} lines
\item \code{bias} for the \emph{Bias} line (when \eqn{\rho < 1})
}

\code{splineKnots} data frame (argument \code{SB_splineKnots}) variables used in the plot:
\itemize{
\item \code{x} for the x-axis values (\emph{t})
\item \code{y} for the \emph{Cubic spline} line and the \emph{Extra knot} and \emph{Original knot} points
\item \code{extraKnot} for the type of knot (\emph{Extra knot} vs. \emph{Original knot})
}

See section \strong{Value} of \code{\link[=benchmarking]{benchmarking()}} and \code{\link[=stock_benchmarking]{stock_benchmarking()}} for more details on these data frames.
}
\examples{
#######
# Preliminary setup

# Quarterly stocks (same annual pattern repeated for 7 years)
qtr_ts <- ts(rep(c(85, 95, 125, 95), 7), start = c(2013, 1), frequency = 4)

# End-of-year stocks
ann_ts <- ts(c(135, 125, 155, 145, 165), start = 2013, frequency = 1)

# Proportional benchmarking
# ... with `benchmarking()` ("Proc Benchmarking" approach)
out_PB <- benchmarking(
  ts_to_tsDF(qtr_ts), 
  ts_to_bmkDF(ann_ts, discrete_flag = TRUE, alignment = "e", ind_frequency = 4),
  rho = 0.729, lambda = 1, biasOption = 3,
  quiet = TRUE)
# ... with `stock_benchmarking()`
out_SB <- stock_benchmarking(
  ts_to_tsDF(qtr_ts), 
  ts_to_bmkDF(ann_ts, discrete_flag = TRUE, alignment = "e", ind_frequency = 4),
  rho = 0.729, lambda = 1, biasOption = 3,
  quiet = TRUE)


#######
# Plot the benchmarking adjustments

# `benchmarking()` adjustments (`out_PB`), without a legend
plot_benchAdj(PB_graphTable = out_PB$graphTable,
              legendPos = NULL)

# Add the `stock_benchmarking()` (`out_SB`) adjustments, with a legend this time
plot_benchAdj(PB_graphTable = out_PB$graphTable,
              SB_graphTable = out_SB$graphTable)

# Add the `stock_benchmarking()` cubic spline actually used to generate the adjustments
# (incl. the extra knots at both ends), with the legend located in the top-left corner
plot_benchAdj(PB_graphTable = out_PB$graphTable,
              SB_graphTable = out_SB$graphTable,
              SB_splineKnots = out_SB$splineKnots,
              legendPos = "topleft")


#######
# Simulate multiple series benchmarking (3 stock series)

qtr_mts <- ts.union(ser1 = qtr_ts, ser2 = qtr_ts * 100, ser3 = qtr_ts * 10)
ann_mts <- ts.union(ser1 = ann_ts, ser2 = ann_ts * 100, ser3 = ann_ts * 10)

# Using argument `allCols = TRUE` (identify stocks with column `varSeries`)
out_SB2 <- stock_benchmarking(
  ts_to_tsDF(qtr_mts),
  ts_to_bmkDF(ann_mts, discrete_flag = TRUE, alignment = "e", ind_frequency = 4),
  rho = 0.729, lambda = 1, biasOption = 3,
  allCols = TRUE,
  quiet = TRUE)

# Adjustments for 2nd stock (ser2)
plot_benchAdj(
  SB_graphTable = out_SB2$graphTable[out_SB2$graphTable$varSeries == "ser2", ])

# Using argument `by = "series"` (identify stocks with column `series`)
out_SB3 <- stock_benchmarking(
  stack_tsDF(ts_to_tsDF(qtr_mts)),
  stack_bmkDF(ts_to_bmkDF(
    ann_mts, discrete_flag = TRUE, alignment = "e", ind_frequency = 4)),
  rho = 0.729, lambda = 1, biasOption = 3,
  by = "series",
  quiet = TRUE)

# Cubic spline for 3nd stock (ser3)
plot_benchAdj(
  SB_splineKnots = out_SB3$splineKnots[out_SB3$splineKnots$series == "ser3", ])
}
\seealso{
\code{\link[=plot_graphTable]{plot_graphTable()}} \link{bench_graphs} \code{\link[=benchmarking]{benchmarking()}} \code{\link[=stock_benchmarking]{stock_benchmarking()}}
}
