% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_model.R
\name{transport_model}
\alias{transport_model}
\title{Transport model}
\usage{
transport_model(
  gtfs_data,
  min_speed = 2,
  max_speed = 80,
  new_speed = NULL,
  parallel = TRUE,
  ncores = NULL,
  spatial_resolution = 100,
  output_path = NULL,
  continue = FALSE
)
}
\arguments{
\item{gtfs_data}{A path to a GTFS file or a GTFS data organized as a list of
\code{data.tables} created with \code{gtfstools::read_gtfs()}.}

\item{min_speed}{numeric (in km/h) or a speed units value. Minimum speed to
be considered as valid. Values below minimum speed will be updated
according to the \code{new_speed} parameter, which can affect the arrival
and  departure times of vehicles at  transit stops. Defaults to \code{2}
km/h.}

\item{max_speed}{numeric (in km/h) or a speed units value. Maximum speed to
be considered as valid. Values above maximum speed will be  updated
according to the \code{new_speed} parameter, which can affect the arrival
and departure times of vehicles at transit stops. Defaults to \code{80}
km/h.}

\item{new_speed}{numeric (in km/h) or a speed units value. Speed value used
to replace the speeds that fall outside the \code{min_speed} and \code{max_speed}
range or which are missing from the GTFS input. When \code{new_speed = NULL}
(the default), the function uses the average speed of the entire GTFS
data feed.}

\item{parallel}{logical. Decides whether the function should run in parallel.
Defaults is \code{TRUE}.}

\item{ncores}{integer. Number of cores to be used in parallel execution. This
argument is ignored if parallel is \code{FALSE}. Default (\code{NULL}) selects
the total number of available cores minus one.}

\item{spatial_resolution}{The spatial resolution in meters. Defaults to \code{100}.
The function only creates points in order to guarantee that the
minimum distance between two consecutive points will be at most the
\code{spatial_resolution} value. If a given GTFS shape_id has two
consecutive points with a distance smaller than the spatial resolution,
the algorithm will not remove such points.}

\item{output_path}{character. A directory path. If \code{NULL} (Default), the
function returns the output. If the user passes a valid \code{passed}, the
output will be saved in the \code{output_path} dir. Note that that the
output of each public transport \code{shape_id} is saved separately in
different files. Setting an \code{output_path} is recommended when working
with large public transport system because the output of the function
can be significantly large.}

\item{continue}{logical. Argument that can be used only with output_path When TRUE,
it skips processing the shape identifiers that were already saved into
files. It is useful to continue processing a GTFS file that was stopped
for some reason. Default value is FALSE.}
}
\value{
A \verb{data.table sf_linestring} object or \code{NULL}.
}
\description{
This function converts a public transport data set in GTFS format into a
GPS-like table with the space-time positions and speeds of public transport
vehicles. The function also allow users to set the spatial resolution of the
output and to adjust the speed of public transport vehicles given a
\code{min_speed} and \code{max_speed} range.
}
\examples{
\donttest{
if (requireNamespace("gtfstools", quietly=TRUE)) {

# read GTFS
gtfs_file <- system.file("extdata/bra_cur_gtfs.zip", package = "gtfs2emis")
gtfs <- gtfstools::read_gtfs(gtfs_file) 

# keep a single trip_id to speed up this example
gtfs_small <- gtfstools::filter_by_trip_id(gtfs, trip_id ="4451136")
  
# run transport model
tp_model <- transport_model(gtfs_data = gtfs_small,
                            min_speed = 2,
                            max_speed = 80,
                            new_speed = 20,
                            spatial_resolution = 100,
                            parallel = FALSE)
  }
}
}
\seealso{
Other Core function: 
\code{\link{emission_model}()}
}
\concept{Core function}
