% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\title{provides performance measures using objects from h2o}
\usage{
performance(perf)
}
\arguments{
\item{perf}{h2o performance object of class "H2OBinomialMetrics"}
}
\value{
numeric vector
}
\description{
takes h2o performance object of class "H2OBinomialMetrics"
             alongside caret confusion matrix and provides different
             model performance measures supported by h2o and caret
}
\examples{

\dontrun{
library(h2o)
h2o.init(ignore_config = TRUE, nthreads = 2, bind_to_localhost = FALSE, insecure = TRUE)
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 30)

# evaluate the model performance
perf <- h2o.performance(aml@leader, xval = TRUE)

# compute more performance measures
performance(perf)

}
}
\author{
E. F. Haghish
}
