# Generated by extendr: Do not edit by hand

# nolint start

#
# This file was created with the following call:
#   .Call("wrap__make_h3o_wrappers", use_symbols = TRUE, package_name = "h3o")

#' @usage NULL
#' @useDynLib h3o, .registration = TRUE
NULL

h3_from_string_ <- function(x) .Call(wrap__h3_from_string_, x)

h3_from_points_ <- function(x, resolution) .Call(wrap__h3_from_points_, x, resolution)

h3_from_xy_ <- function(x, y, resolution) .Call(wrap__h3_from_xy_, x, y, resolution)

h3_boundaries_ <- function(x) .Call(wrap__h3_boundaries_, x)

h3_to_strings <- function(x) .Call(wrap__h3_to_strings, x)

vctrs_class <- function() .Call(wrap__vctrs_class)

sfc_to_cells_ <- function(x, resolution, containment) .Call(wrap__sfc_to_cells_, x, resolution, containment)

#' H3 Inspection Functions
#'
#' Functions that provide metadata about H3 indexes.
#'
#' @param x an `H3` vector.
#'
#' @details
#' - `h3_resolution()`: returns the resolution of each H3 cell.
#' - `h3_base_cell()`: returns the base cell integer.
#' - `is_valid_h3()`: given a vector of H3 index string IDs, determine if they are valid.
#' - `is_res_class_iii()`: determines if an H3 cell has Class III orientation.
#' - `is_pentagon()`: determines if an H3 cell is one of the rare few pentagons.
#' - `get_face_count()`: returns the number of faces that intersect with the H3 index.
#'
#' @export
#' @rdname inspection
#' @examples
#' cells_ids <-c(
#'     "85e22da7fffffff", "85e35ad3fffffff", 
#'     "85e22daffffffff", "85e35adbfffffff", 
#'     "85e22db7fffffff", "85e35e6bfffffff",
#'     "85e22da3fffffff"
#'   ) 
#'   
#' cells <- h3o::h3_from_strings(cells_ids)
#' 
#' h3_resolution(cells)
#' h3_base_cell(cells)
#' is_valid_h3(c("85e22db7fffffff", NA, "oopsies"))
#' is_res_class_iii(cells)
#' is_res_class_iii(h3_from_xy(0, 0, 10))
#' is_pentagon(h3_from_strings("08FD600000000000"))
#' get_face_count(cells)
#' @returns
#' See details.
h3_resolution <- function(x) .Call(wrap__h3_resolution, x)

#' @export
#' @rdname inspection
h3_base_cell <- function(x) .Call(wrap__h3_base_cell, x)

#' @export
#' @rdname inspection
is_valid_h3 <- function(x) .Call(wrap__is_valid_h3, x)

#' @export
#' @rdname inspection
is_res_class_iii <- function(x) .Call(wrap__is_res_class_iii, x)

#' @export
#' @rdname inspection
is_pentagon <- function(x) .Call(wrap__is_pentagon, x)

#' @export
#' @rdname inspection
get_face_count <- function(x) .Call(wrap__get_face_count, x)

get_parents_ <- function(x, resolution) .Call(wrap__get_parents_, x, resolution)

get_children_ <- function(x, resolution) .Call(wrap__get_children_, x, resolution)

get_children_count_ <- function(x, resolution) .Call(wrap__get_children_count_, x, resolution)

get_children_center_ <- function(x, resolution) .Call(wrap__get_children_center_, x, resolution)

get_children_position_ <- function(x, resolution) .Call(wrap__get_children_position_, x, resolution)

get_children_at_ <- function(x, position, resolution) .Call(wrap__get_children_at_, x, position, resolution)

compact_cells_ <- function(x) .Call(wrap__compact_cells_, x)

uncompact_cells_ <- function(x, resolution) .Call(wrap__uncompact_cells_, x, resolution)

h3_to_geo_ <- function(x) .Call(wrap__h3_to_geo_, x)

h3_to_points_ <- function(x) .Call(wrap__h3_to_points_, x)

h3_to_vertexes_ <- function(x) .Call(wrap__h3_to_vertexes_, x)

is_nb_pairwise_ <- function(x, y) .Call(wrap__is_nb_pairwise_, x, y)

is_nb_sparse_ <- function(x, y) .Call(wrap__is_nb_sparse_, x, y)

h3_edges_pairwise_ <- function(x, y) .Call(wrap__h3_edges_pairwise_, x, y)

h3_edges_sparse_ <- function(x, y) .Call(wrap__h3_edges_sparse_, x, y)

is_valid_edge_ <- function(x) .Call(wrap__is_valid_edge_, x)

h3_edge_from_strings_ <- function(x) .Call(wrap__h3_edge_from_strings_, x)

get_directed_origin_ <- function(x) .Call(wrap__get_directed_origin_, x)

get_directed_destination_ <- function(x) .Call(wrap__get_directed_destination_, x)

get_directed_cells_ <- function(x) .Call(wrap__get_directed_cells_, x)

h3_edges_ <- function(x) .Call(wrap__h3_edges_, x)

edge_boundary_ <- function(x) .Call(wrap__edge_boundary_, x)

edges_to_strings <- function(x) .Call(wrap__edges_to_strings, x)

edge_vctrs <- function() .Call(wrap__edge_vctrs)

grid_disk_fast_ <- function(x, k) .Call(wrap__grid_disk_fast_, x, k)

grid_disk_safe_ <- function(x, k) .Call(wrap__grid_disk_safe_, x, k)

grid_distances_ <- function(x, k) .Call(wrap__grid_distances_, x, k)

grid_ring_ <- function(x, k) .Call(wrap__grid_ring_, x, k)

grid_path_cells_ <- function(x, y) .Call(wrap__grid_path_cells_, x, y)

grid_path_cells_size_ <- function(x, y) .Call(wrap__grid_path_cells_size_, x, y)

grid_distance_ <- function(x, y) .Call(wrap__grid_distance_, x, y)

local_ij_ <- function(x, y) .Call(wrap__local_ij_, x, y)

H3DEdge <- new.env(parent = emptyenv())

H3DEdge$new <- function(x, y) .Call(wrap__H3DEdge__new, x, y)

H3DEdge$to_id <- function() .Call(wrap__H3DEdge__to_id, self)

H3DEdge$length <- function(unit) .Call(wrap__H3DEdge__length, self, unit)

#' @export
`$.H3DEdge` <- function (self, name) { func <- H3DEdge[[name]]; environment(func) <- environment(); func }

#' @export
`[[.H3DEdge` <- `$.H3DEdge`


# nolint end
