% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy_3d}
\alias{entropy_3d}
\title{3D entropy}
\usage{
entropy_3d(data, bw, grid_size, relative = FALSE)
}
\arguments{
\item{data}{data.frame with three columns for x, y, and z coordinates.}

\item{bw}{Bandwidth to use in 2D kernel density estimator.}

\item{grid_size}{Size of binning grid, in the unit of the data.}

\item{relative}{Logical. Rescale entropy relative to the maximum entropy
given the number of grid cells? Defaults to FALSE.}
}
\value{
Entropy value.
}
\description{
Calculates 3D entropy
}
\details{
3D entropy consists of three components, including the projected
2D entropy of the XY plane ($CE_xy$), the projected entropy of the
XZ plane ($CE_xz$), and the projected entropy of the
YZ plane ($CE_yz$), and the final entropy estimate is calculated
as follows: $sqrt(CE_xy^2 + CE_xz^2 + CE_yz^2)$.
}
\examples{
dta <- data.frame(x = rnorm(100,5,1), y = rnorm(100,5,1), z = rnorm(100,5,1))
entropy_3d(dta, bw = 0.5, 0.25)
entropy_3d(dta, bw = 0.5, 0.25, relative = TRUE)
}
\references{
X. Liu, Q. Ma, X. Wu, T. Hu, Z. Liu, L. Liu, Q. Guo, Y. Su (2022). A novel entropy-based method to quantify forest canopy structural complexity from multiplatform lidar point clouds. Remote Sens. Environ. 282, 113280.
}
