% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_hvar.R
\name{fd_hvar}
\alias{fd_hvar}
\title{Calculate fractal Dimension using the height variation method}
\usage{
fd_hvar(
  data,
  lvec,
  regmethod = "mean",
  keep_data = FALSE,
  plot = FALSE,
  parallel = FALSE,
  ncores = (parallel::detectCores() - 1)
)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer or dataframe (output of hvar function)}

\item{lvec}{Vector of scales to use for calculation.}

\item{regmethod}{Method to use for linear regression between scale (lvec) and height range. One of \code{raw} (all data), \code{mean} (default) \code{median} or \code{ends} (minimum and maximum scale only)}

\item{keep_data}{Keep the data used for fd calculation? defaults to FALSE}

\item{plot}{Logical. Show plot of scales relative to data?}

\item{parallel}{Logical. Use parallel processing? Note: parallel must be installed.}

\item{ncores}{Number of cores to use when parallel = TRUE.}
}
\value{
A value for fractal dimension, typically between 2 and 3 or a list if keep_data = TRUE.
}
\description{
Calculate fractal Dimension using the height variation method
}
\details{
Calculates fractal dimension using the height variation regression.
If \code{lvec} is not specified, a default based on resolution and extent will be used.
\code{data} can be a DEM or a \code{data.frame} with columns labeled \code{l} and \code{h} for
grid cell length and height range of that cell, respectively (output of \code{\link[=hvar]{hvar()}}).
A rule of thumb is that \code{l} should range an order of magnitude.
However, large ranges also
average-out fractal dimension of a surface that might have
phase transitions, and therefore a thorough exploration of height ranges is suggested using the \code{plot}.
\code{regmethod} specifies whether data is summarized by taking the mean or median of height ranges across scales or all data is used.
\code{regmethod} "raw" is not recommended because the regression will give much more weight to the lower scales that include more points and likely underestimate D.
}
\examples{

\donttest{
dem <- habtools::dem_crop(horseshoe, x0 = -469, y0 = 1267, L = 2, plot = TRUE)
fd_hvar(dem, lvec = c(0.125, 0.25, 0.5, 1, 2))
fd_hvar(dem, regmethod = "mean", plot = TRUE, keep_data = TRUE)
fd_hvar(dem, regmethod = "median", plot = TRUE, keep_data = TRUE)
fd_hvar(dem)
}
}
