% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.hal9001}
\alias{predict.hal9001}
\title{Prediction from HAL fits}
\usage{
\method{predict}{hal9001}(
  object,
  new_data,
  new_X_unpenalized = NULL,
  offset = NULL,
  type = c("response", "link"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{hal9001}, containing the results of
fitting the Highly Adaptive Lasso, as produced by \code{\link{fit_hal}}.}

\item{new_data}{A \code{matrix} or \code{data.frame} containing new data
(i.e., observations not used for fitting the \code{hal9001} object that's
passed in via the \code{object} argument) for which the \code{hal9001}
object will compute predicted values.}

\item{new_X_unpenalized}{If the user supplied \code{X_unpenalized} during
training, then user should also supply this matrix with the same number of
observations as \code{new_data}.}

\item{offset}{A vector of offsets. Must be provided if provided at training.}

\item{type}{Either "response" for predictions of the response, or "link" for
un-transformed predictions (on the scale of the link function).}

\item{...}{Additional arguments passed to \code{predict} as necessary.}
}
\value{
A \code{numeric} vector of predictions from a \code{hal9001} object.
}
\description{
Prediction from HAL fits
}
\details{
Method for computing and extracting predictions from fits of the
Highly Adaptive Lasso estimator, returned as a single S3 objects of class
\code{hal9001}.
}
\note{
This prediction method does not function similarly to the equivalent
method from \pkg{glmnet}. In particular, this procedure will not return a
subset of lambdas originally specified in calling \code{\link{fit_hal}}
nor result in re-fitting. Instead, it will return predictions for all of
the lambdas specified in the call to \code{\link{fit_hal}} that constructs
\code{object}, when \code{fit_control}'s \code{cv_select} is set to
\code{FALSE}. When \code{fit_control}'s \code{cv_select} is set to
\code{TRUE}, predictions will only be returned for the value of lambda
selected by cross-validation.
}
