# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate the haversine distance in kilometers given lat/lon pairs
#'
#' @param lat1 A vector of latitudes
#' @param lon1 A vector of longitudes
#' @param lat2 A vector of latitudes
#' @param lon2 A vector of longitudes
#' @return a vector of distances in kilometers
#' @export
#' @examples
#' # simple haversine calculation 
#' lon1 <- runif(-160, -60, n = 10e6)
#' lat1 <- runif(40, 60, n = 10e6)
#' lon2 <- runif(-160, -60, n = 10e6)
#' lat2 <- runif(40, 60, n = 10e6)
#' df <- data.frame(lat1, lon1, lat2, lon2)
#' df$havers <- haversine(df$lat1, df$lon1, df$lat2, df$lon2)
haversine <- function(lat1, lon1, lat2, lon2) {
    .Call(`_hans_haversine`, lat1, lon1, lat2, lon2)
}

