% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHazeFactor.R
\name{getHazeFactor}
\alias{getHazeFactor}
\title{The haze factor for a given RGB array.}
\usage{
getHazeFactor(rgbArray, mu = 5.1, nu = 2.9, sigma = 0.2461)
}
\arguments{
\item{rgbArray}{RGB array (W x H x 3) where the third dimension contains R, G and B channels, values varying from 0 to 1.}

\item{mu}{function parameter}

\item{nu}{function parameter}

\item{sigma}{function parameter}
}
\value{
a list of two numeric values:haze as haze degree and A0 as the global atmospheric light
}
\description{
The haze factor for a given RGB array.
}
\examples{
library(jpeg)

img <- readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))

h <- getHazeFactor(img)
d <- getDarkness(img)
b <- getBrightness(img)
c <- getContrast(img)

par(mfcol = c(2, 2), mar = c(0.5, 0.5, 0.5, 0.5))

plotRGBArray(img)
mtext(text = 'RGB', side = 3, line = -2, adj = 0.05, font = 2, col = 'red')
mtext(text = paste0('Hazeness: ', signif(h$haze, 2)), side = 1, line = -2, adj = 0.05)
mtext(text = paste0('A0: ', signif(h$A0, 2)), side = 1, line = -1, adj = 0.05)

plotRGBArray(d)
mtext(text = 'Darkness', side = 3, line = -2, adj = 0.05, font = 2, col = 'red')

plotRGBArray(b)
mtext(text = 'Brightness', side = 3, line = -2, adj = 0.05, font = 2, col = 'red')

plotRGBArray(c)
mtext(text = 'Contrast', side = 3, line = -2, adj = 0.05, font = 2, col = 'red')

}
\seealso{
\code{\link{getDarkness}}, \code{\link{getBrightness}} and \code{\link{getContrast}}
}
