% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassoIVselectZ.R
\name{coef.rlassoIVselectZ}
\alias{coef.rlassoIVselectZ}
\title{Coefficients from S3 objects \code{rlassoIVselectZ}}
\usage{
\method{coef}{rlassoIVselectZ}(object, complete = TRUE, selection.matrix = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{rlassoIVselectZ}, usually a result of a call 
\code{rlassoIVselectZ} or \code{rlassoIV} with options \code{select.X=FALSE} and
\code{select.Z=TRUE}.}

\item{complete}{general option of the function \code{coef}.}

\item{selection.matrix}{if TRUE, a selection matrix is returned that indicates the selected variables from each first stage regression.
Default is set to FALSE. See section on details for more information.}

\item{...}{further arguments passed to functions coef.}
}
\description{
Method to extract coefficients from objects of class \code{rlassoIVselectZ}.
}
\details{
Printing coefficients and selection matrix for S3 object \code{rlassoIVselectZ}. The columns of the selection matrix report the selection index for the first stage lasso regressions as specified
\code{rlassoIVselectZ} command, i.e., the selected variables for each of the endogenous variables. \code{"x"} indicates that a variable has been selected, i.e., the corresponding estimated coefficient is different from zero.
The very last column collects all variables that have been selected in at least one of the lasso regressions.
}
\examples{
\dontrun{
lasso.IV.Z = rlassoIVselectZ(x=x, d=d, y=y, z=z)
data(EminentDomain)
z <- EminentDomain$logGDP$z # instruments
x <- EminentDomain$logGDP$x # exogenous variables
y <- EminentDomain$logGDP$y # outcome varialbe
d <- EminentDomain$logGDP$d # treatment / endogenous variable
lasso.IV.Z = rlassoIVselectZ(x=x, d=d, y=y, z=z)
coef(lasso.IV.Z) # Default behavior
coef(lasso.IV.Z, selection.matrix = T)
}
}
