% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vigitel.R
\name{vigitel_variables}
\alias{vigitel_variables}
\title{List VIGITEL variables}
\usage{
vigitel_variables(year, cache_dir = NULL)
}
\arguments{
\item{year}{Integer. Year of the survey.}

\item{cache_dir}{Character. Optional custom cache directory. If NULL (default),
uses the standard user cache directory. Use \code{tempdir()} for temporary
storage that won't persist.}
}
\value{
A character vector of variable names
}
\description{
Returns a character vector of variable names available in a VIGITEL
survey year.
}
\examples{
\donttest{
# list variables for 2023 (uses tempdir to avoid leaving files)
vigitel_variables(2023, cache_dir = tempdir())
}
}
