% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-mesh-generator.R
\name{generate_mesh_data}
\alias{generate_mesh_data}
\title{Generate Mesh Data}
\usage{
generate_mesh_data(.side_length = 1, .n_seg = 1)
}
\arguments{
\item{.side_length}{A single numeric value representing the side length of
the square.}

\item{.n_seg}{A positive integer representing the number of segments along
each side of the square.}
}
\value{
A list containing:
\describe{
\item{nodes}{A matrix with coordinates of the nodes.}
\item{edges}{A list of edges connecting the nodes.}
\item{nodes_df}{A data frame of nodes for ggplot.}
\item{edges_df}{A data frame of edges for ggplot.}
\item{plot}{A ggplot object visualizing the nodes and edges.}
}
Additionally, the list contains attributes:
\describe{
\item{side_length}{The side length used to generate the mesh.}
\item{n_seg}{The number of segments used to generate the mesh.}
\item{nodes_df_dim}{Dimensions of the nodes data frame.}
\item{edges_df_dim}{Dimensions of the edges data frame.}
}
}
\description{
This function creates a square mesh by sampling nodes uniformly
on a square and then connecting these nodes with edges. The nodes are
distributed based on the provided side length and number of segments. Horizontal,
vertical, and diagonal edges are generated to fully connect the mesh.
The function returns a list containing the nodes and edges, along with data
frames and a ggplot object for visualization.
}
\details{
This function generates a mesh of nodes and edges based on the provided side
length and number of segments.

This function creates a square mesh of nodes and edges, where the
nodes are sampled uniformly on a square. The edges are generated to connect
the nodes horizontally, vertically, and diagonally.
}
\examples{
generate_mesh_data(1, 1)
generate_mesh_data(1, 2)

}
\seealso{
Other Data Generation: 
\code{\link{get_juiced_data}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Generation}
