% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_plot.R
\name{pulse_plot_raw}
\alias{pulse_plot_raw}
\title{Plot raw PULSE data}
\usage{
pulse_plot_raw(heart_rates, ID, target_time = NULL, range = 0, target_i = NULL)
}
\arguments{
\item{heart_rates}{the output from \code{\link[=PULSE]{PULSE()}} (or \code{\link[=pulse_heart]{pulse_heart()}} and any of the downstream functions).}

\item{ID}{character string naming a single target channel id (must match exactly); defaults to \code{NULL}, which results in all IDs being plotted}

\item{target_time}{a target time expressed as POSIX time or a string that can be converted directly by \code{as.POSIXct()}; \code{target_i} will be computed as the window closest to the \code{target_time}}

\item{range}{numeric, defaults to \code{0} (only \code{target_i} will be plotted); value indicating how many more windows to plot (centered around the target window, i.e., if \code{target_i = 5} and \code{range = 2}, windows 3 to 7 will be plotted, with window 5 at the center)}

\item{target_i}{numeric; value pointing to the index of the target window (which can be found in the column \code{i} of \code{heart_rates})}
}
\value{
A ggplot object that can be augmented using ggplot2 syntax or plotted right away
}
\description{
A shortcut function based on \code{ggplot2} to facilitate the quick inspection of the raw data underlying the analysis (with the peaks detected signaled with red dots). Useful to visually inspect the performance of the algorithm.
}
\details{
This function is \strong{NOT meant} for high-level displaying of the data - it's simply a quick shortcut to facilitate data inspection.

When inspecting the plot, assess if red dots top all heartbeats and no more than that. Difficult datasets may result in true heartbeats being missed (false negatives) or non-heartbeats (noise) being erroneously detected (false positives). Note that the wider the time window (controlled by the \code{window_width_secs} parameter in \code{\link[=pulse_split]{pulse_split()}}) and the higher the heartbeat rate, the less critical are a few false positives or negatives (over a 10 secs window, missing 1 peak in 10 results in hz to drop by 10\% (from 1 to 0.9), while over a 30 secs window, missing 1 peak in 30 results in a drop of 3.33\% (from 1 to 0.967), and missing 1 peak in 60 results in a drop of just 1.7\%.
}
\examples{
## Begin prepare data ----
paths <- pulse_example()
chn <- paste0("c", formatC(1:10, width = 2, flag = "0"))
heart_rates <- PULSE(
  paths,
  discard_channels  = chn[-8],
  raw_v_smoothed = FALSE,
  show_progress = FALSE)
## End prepare data ----

# Single window (in both cases, the 5th window)
# using a target date and time
pulse_plot_raw(heart_rates, "c08", "2024-10-01 10:56")
# using the index
pulse_plot_raw(heart_rates, "c08", target_i = 5)

# Multiple windows (less detail, but more context)
pulse_plot_raw(heart_rates, "c08", "2024-10-01 10:56", 2)

# The plot can be modified using ggplot2 syntax
pulse_plot_raw(heart_rates, "c08", target_i = 5) + ggplot2::theme_classic()
}
\seealso{
\itemize{
\item use \code{\link[=pulse_plot]{pulse_plot()}} to plot processed PULSE data for a several channels
\item \code{\link[=PULSE]{PULSE()}} (or \code{\link[=pulse_heart]{pulse_heart()}} and any of the downstream functions) generates the input for \code{pulse_plot_raw}
\item call \code{\link[=pulse_normalize]{pulse_normalize()}} to anchor heart beat data from each channel to a reference period during the experiment
}
}
