% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_sequential.R
\name{prepare_sequential}
\alias{prepare_sequential}
\title{Sequentially prepare data for sandwich smooth}
\usage{
prepare_sequential(
  import_list,
  import_fun = base::readRDS,
  x,
  splines,
  assembled,
  package = "base",
  call_args = list(),
  ...
)
}
\arguments{
\item{import_list}{A vector or list whose elements tell \code{import_fun}
which files to import.}

\item{import_fun}{A function that will read each observation into memory
based on the elements of \code{import_list}.}

\item{x}{The list of arguments at which to evaluate each
of the splines used to construct \code{assembled}.}

\item{splines}{A list of spline-related objects. Each element of
\code{splines} corresponds to the set of splines for the corresponding
element of \code{x}.}

\item{assembled}{A list of \code{assembled_splines}.  See
Examples.}

\item{package}{A character string indicating the package to use for the
computations. The choices are \code{"base"}, \code{"parallel"},
\code{"pbapply"}, \code{"future.apply"}, and \code{"Rmpi"}. The default is
\code{"base"}, in which case a standard \code{for} loop is used. If
\code{package == "parallel"}, then \code{\link[parallel]{mclapply}} is
used, which is only appropriate when \code{mc.cores} is integer-valued or
\code{NULL}. If \code{package == "pbapply"}, then
\code{\link[pbapply]{pblapply}} is used, which automatically provides a
progress bar. If \code{package == "future.apply"}, then
\code{\link[future.apply]{future_lapply}} is used. If \code{package ==
"Rmpi"}, then \code{\link[Rmpi]{mpi.applyLB}} is used.}

\item{call_args}{A named list providing relevant arguments to the
\code{\link[parallel]{mclapply}}, \code{\link[pbapply]{pblapply}},
\code{\link[future.apply]{future_lapply}}, or
\code{\link[Rmpi]{mpi.applyLB}} depending on the value of \code{package}.}

\item{...}{Not implemented}
}
\value{
A \code{prepared_sequential} object
}
\description{
Sequentially prepare each observation for smoothing. It is assumed that each
observation resides in its own file and that \code{do.call(import_fun,
list(import_list[i]))} will import the data associated with observation
\code{i} into memory. The \code{import_fun} argument should be a function
after the style of \code{\link[base]{readRDS}}, where the object can be
assigned a name once it is read in. The \code{import_fun} argument should NOT
be like \code{\link[base]{load}}, where the object loaded has a preassigned
name.
}
\seealso{
\code{\link{prepare}}, \code{\link[parallel]{mclapply}},
  \code{\link[pbapply]{pblapply}}, \code{\link[future.apply]{future_lapply}},
  \code{\link[Rmpi]{mpi.applyLB}}
}
\author{
Joshua P. French
}
