% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctstm.R
\name{create_IndivCtstmTrans}
\alias{create_IndivCtstmTrans}
\alias{create_IndivCtstmTrans.flexsurvreg_list}
\alias{create_IndivCtstmTrans.flexsurvreg}
\alias{create_IndivCtstmTrans.params_surv}
\alias{create_IndivCtstmTrans.params_surv_list}
\title{Create \code{IndivCtstmTrans} object}
\usage{
create_IndivCtstmTrans(object, ...)

\method{create_IndivCtstmTrans}{flexsurvreg_list}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward"),
  n = 1000,
  uncertainty = c("normal", "none"),
  ...
)

\method{create_IndivCtstmTrans}{flexsurvreg}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward"),
  n = 1000,
  uncertainty = c("normal", "none"),
  ...
)

\method{create_IndivCtstmTrans}{params_surv}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward", "mix", "mixt"),
  reset_states = NULL,
  transition_types = NULL,
  ...
)

\method{create_IndivCtstmTrans}{params_surv_list}(
  object,
  input_data,
  trans_mat,
  clock = c("reset", "forward", "mix", "mixt"),
  reset_states = NULL,
  transition_types = NULL,
  ...
)
}
\arguments{
\item{object}{An object of the appropriate class containing either a fitted
multi-state model or parameters of a multi-state model.}

\item{...}{Further arguments passed to \code{IndivCtstmTrans$new()} in \code{\link{IndivCtstmTrans}}.}

\item{input_data}{An object of class \code{expanded_hesim_data} returned by
\code{\link{expand.hesim_data}}.}

\item{trans_mat}{The transition matrix describing the states and transitions in a
multi-state model in the format from the \code{\link[mstate:mstate-package]{mstate}} package. See \code{\link{IndivCtstmTrans}}.}

\item{clock}{"reset" for a clock-reset model, "forward" for a clock-forward model,
"mix" for a mixture by state, and "mixt" for a mixture by transition
of clock-reset and clock-forward models. See the field \code{clock} in \code{\link{IndivCtstmTrans}}.}

\item{n}{Number of random observations to draw. Not used if \code{uncertainty = "none"}.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled.
If \code{"normal"}, then parameters are randomly drawn from their multivariate normal
distribution. If \code{"none"}, then only point estimates are returned.}

\item{reset_states}{A vector denoting the states in which time resets. See the field
\code{reset_states} in \code{\link{IndivCtstmTrans}}.}

\item{transition_types}{A vector denoting the type for each transition. See the field
\code{transition_types} in \code{\link{IndivCtstmTrans}}.}
}
\value{
Returns an \code{\link[R6:R6Class]{R6::R6Class}} object of class \code{\link{IndivCtstmTrans}}.
}
\description{
A generic function for creating an object of class \code{\link{IndivCtstmTrans}}.
}
\details{
Disease models may either be created from a fitted statistical
model or from a parameter object. In the case of the former, \code{input_data}
is a data frame like object that is used to look for variables from
the statistical model that are required for simulation. In this sense,
\code{input_data} is very similar to the \code{newdata} argument in most \code{\link[=predict]{predict()}}
methods (e.g., see \code{\link[=predict.lm]{predict.lm()}}). In other words, variables used in the
\code{\link{formula}} of the statistical model must also be in \code{input_data}.

In the case of the latter, the columns of \code{input_data} must be named in a
manner that is consistent with the parameter object. In the typical case
(e.g., with \code{\link{params_surv}} or \code{\link{params_mlogit}}), the parameter object
contains coefficients from a regression model, usually stored as matrix
where rows index parameter samples (i.e., for a probabilistic sensitivity
analysis) and columns index model terms. In such instances, there must
be one column from \code{input_data} with the same name as each model term in the
coefficient matrix; that is, the columns in \code{input_data} are matched with
the columns of the coefficient matrices by name. If there are model terms
in the coefficient matrices that are not contained in \code{input_data}, then
an error will be thrown.
}
\seealso{
See \code{\link{IndivCtstmTrans}} and \code{\link{IndivCtstm}} for examples.
}
