% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetu_diagnostic.R
\name{hetu_diagnostic}
\alias{hetu_diagnostic}
\alias{pin_diagnostic}
\title{Diagnostics Tool for Personal Identity Codes}
\usage{
hetu_diagnostic(pin, extract = NULL)

pin_diagnostic(pin, extract = NULL)
}
\arguments{
\item{pin}{Finnish personal identification number as a character vector,
or vector of identification numbers as a character vectors}

\item{extract}{Extract only selected part of the diagnostic information.
Valid values are "\code{hetu}", "\code{is.temp}", "\code{valid.p.num}",
"\code{valid.ctrl.char}", "\code{correct.ctrl.char}", "\code{valid.date}",
"\code{valid.day}", "\code{valid.month}", "\code{valid.length}",
"\code{valid.century}". If \code{NULL} (default), returns all information.}
}
\value{
A data.frame containing diagnostic checks about PINs.
}
\description{
Prints information on the tests that are used
   to confirm or reject the validity of each personal identity code.
}
\examples{
diagnosis_example <- c("010101-0102", "111111-111Q",
"010101B0101", "320101-0101", "011301-0101",
"010101-01010", "010101-0011", "010101-9011", "010101-901S")
## Print all diagnostics for various fake personal identity codes
hetu_diagnostic(diagnosis_example)
# Extract century-related checks
hetu_diagnostic(diagnosis_example, extract = "valid.century")
# Print a summary in natural language
summary(hetu_diagnostic(diagnosis_example))
diagnosis_example <- c("010101-0102", "111111-111Q",
"010101B0101", "320101-0101", "011301-0101",
"010101-01010", "010101-0011")
## Print all diagnoses
pin_diagnostic(diagnosis_example)
}
\seealso{
\code{\link{hetu}} for the main function on which
   \code{hetu_diagnostic} relies on.
}
