% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{ttbGreedyModel}
\alias{ttbGreedyModel}
\title{Greedy Take The Best}
\usage{
ttbGreedyModel(
  train_data,
  criterion_col,
  cols_to_fit,
  fit_name = "ttbGreedyModel"
)
}
\arguments{
\item{train_data}{Training/fitting data as a matrix or data.frame.}

\item{criterion_col}{The index of the column in train_data that has the
criterion.}

\item{cols_to_fit}{A vector of column indices in train_data, used to fit
the criterion.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.  It is useful to change this to a unique name
if you are making multiple fits, e.g. "ttb1", "ttb2", "ttbNoReverse."}
}
\value{
An object of \code{\link[base]{class}} ttbGreedyModel, which can
  be passed in to \code{\link{predictPair}}.
}
\description{
A variant of the Take The Best heuristic with a different cue order, namely
using conditional cue validity, where the validity of a cue is judged only
on row pairs not already decided by prior cues.  Specifically, it uses the
cue ranks returned by \code{\link{conditionalCueValidityComplete}}.
}
\examples{
## A data set where Take the Best and Greedy Take the Best disagree.
matrix <- cbind(y=c(3:1), x1=c(1,0,0), x2=c(1,0,1))
ttb <- ttbModel(matrix, 1, c(2,3))
ttb$cue_validities
# Returns
#  x1  x2 
# 1.0 0.5
ttbG <- ttbGreedyModel(matrix, 1, c(2:3))
ttbG$cue_validities
# Returns
#  x1  x2 
#   1   1
# because after using x1, only decisions between row 2 and 3 are left,
# and x2 gets 100\% right  on those (after reversal).  However, these
# cue_validities depend on using x1, first, so cue_rank is key.
ttbG$cue_ranks
# Returns
#  x1  x2 
#   1   2

# Now see how this affects predictions on row 2 vs. 3.
# Take the best guesses (output 0).
predictPair(oneRow(matrix, 2), oneRow(matrix, 3), ttb)
# Greedy Take The Best selects row 2 (output 1).
predictPair(oneRow(matrix, 2), oneRow(matrix, 3), ttbG)

}
\references{
Martignon, L., & Hoffrage, U.  (2002).  Fast, frugal, and fit: Simple
heuristics for paired comparisons.  Theory and Decision, 52: 29-71.
}
\seealso{
\code{\link{conditionalCueValidityComplete}} for the metric used to sort cues.

\code{\link{ttbModel}} for the original version of Take The Best.

\code{\link{predictPair}} for predicting whether row1 is greater.

\code{\link{predictPairProb}} for predicting the probability row1 is
greater.
}
