% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_chromosomes_length.R
\name{combine_chrom_length}
\alias{combine_chrom_length}
\title{Computes chromosomes' length from list}
\usage{
combine_chrom_length(x)
}
\arguments{
\item{x}{A list of \code{GWAS_data}, \code{DE_data} or \code{CAN_data} objects.}
}
\value{
A tibble with two columns: \code{chromosome} (chromosome name) and
\code{length} (chromosome length in base pair).
}
\description{
Computes the length (in bp) of each chromosome from a list of GWAS and
DE results as well as candidate gene lists.
}
\examples{
x <- get_example_data()
y <- list("GWAS" = GWAS_data(x[["GWAS"]]),
          "DE" = DE_data(x[["DE"]]),
          "CAN" = CAN_data(x[["CAN"]]))

combine_chrom_length(y)
}
