% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVSK_skew_t.R
\name{design_MVSK_portfolio_via_skew_t}
\alias{design_MVSK_portfolio_via_skew_t}
\title{Design MVSK portfolio without shorting based on the parameters of generalized hyperbolic skew-t distribution}
\usage{
design_MVSK_portfolio_via_skew_t(
  lambda,
  X_skew_t_params,
  w_init = rep(1/length(X_skew_t_params$mu), length(X_skew_t_params$mu)),
  method = c("L-MVSK", "DC", "Q-MVSK", "SQUAREM", "RFPA", "PGD"),
  gamma = 1,
  zeta = 1e-08,
  tau_w = 0,
  beta = 0.5,
  tau = 1e+05,
  initial_eta = 5,
  maxiter = 1000,
  ftol = 1e-06,
  wtol = 1e-06,
  stopval = -Inf
)
}
\arguments{
\item{lambda}{Numerical vector of length 4 indicating the weights of first four moments.}

\item{X_skew_t_params}{List of fitted parameters, including location vector, skewness vector, scatter matrix, and the degree of freedom,
see \code{\link{estimate_skew_t}()}.}

\item{w_init}{Numerical vector indicating the initial value of portfolio weights.}

\item{method}{String indicating the algorithm method, must be one of: "L-MVSK", "DC", "Q-MVSK", "SQUAREM", "RFPA", "PGD".}

\item{gamma}{Number (0 < gamma <= 1) indicating the initial value of gamma for the Q-MVSK method.}

\item{zeta}{Number (0 < zeta < 1) indicating the diminishing parameter of gamma for the Q-MVSK method.}

\item{tau_w}{Number (>= 0) guaranteeing the strong convexity of approximating function.}

\item{beta}{Number (0 < beta < 1) decreasing the step size of the projected gradient methods.}

\item{tau}{Number (tau > 0) hyper-parameters for the fixed-point acceleration.}

\item{initial_eta}{Initial eta for projected gradient methods}

\item{maxiter}{Positive integer setting the maximum iteration.}

\item{ftol}{Positive number setting the convergence criterion of function objective.}

\item{wtol}{Positive number setting the convergence criterion of portfolio weights.}

\item{stopval}{Number setting the stop value of objective.}
}
\value{
A list containing the following elements:
\item{\code{w}}{Optimal portfolio vector.}
\item{\code{cpu_time_vs_iterations}}{Time usage over iterations.}
\item{\code{objfun_vs_iterations}}{Objective function over iterations.}
\item{\code{iterations}}{Iterations index.}
\item{\code{convergence}}{Boolean flag to indicate whether or not the optimization converged.}
\item{\code{moments}}{Moments of portfolio return at optimal portfolio weights.}
}
\description{
Design MVSK portfolio without shorting based on the parameters of generalized hyperbolic skew-t distribution:
\preformatted{
  minimize     - lambda1*phi1(w) + lambda2*phi2(w)
               - lambda3*phi3(w) + lambda4*phi4(w)
  subject to   w>=0, sum(w) == 1.
}
}
\examples{
library(highOrderPortfolios)
data(X50)

# estimate skew t distribution
X_skew_t_params <- estimate_skew_t(X50)

# decide moment weights
xi <- 10
lambda <- c(1, 4, 10, 20)

# portfolio optimization
sol <- design_MVSK_portfolio_via_skew_t(lambda, X_skew_t_params, method = "RFPA", tau = 10)

}
\references{
X. Wang, R. Zhou, J. Ying, and D. P. Palomar, "Efficient and Scalable High-Order Portfolios Design via Parametric Skew-t Distribution,"
Available in arXiv, 2022. <https://arxiv.org/pdf/2206.02412.pdf>.
}
\author{
Xiwen Wang, Rui Zhou and Daniel P. Palomar
}
