% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{leapfrog}
\alias{leapfrog}
\title{Leapfrog Algorithm for Hamiltonian Monte Carlo}
\usage{
leapfrog(
  theta_lf,
  r,
  epsilon,
  glogPOSTERIOR,
  Minv,
  constrain,
  lastSTEP = FALSE,
  ...
)
}
\arguments{
\item{theta_lf}{starting parameter vector}

\item{r}{starting momentum vector}

\item{epsilon}{Step-size parameter for \code{leapfrog}}

\item{glogPOSTERIOR}{Function to calculate and return the gradient of the log posterior given a vector of values of \code{theta}}

\item{Minv}{Inverse Mass matrix}

\item{constrain}{Optional vector of which parameters in \code{theta} accept positive values only.  Default is that all parameters accept all real numbers}

\item{lastSTEP}{Boolean indicating whether to calculate the last half-step of the momentum update}

\item{...}{Additional parameters passed to glogPOSTERIOR}
}
\value{
List containing two elements:  \code{theta.new} the ending value of theta and \code{r.new} the ending value of the momentum
}
\description{
Runs a single iteration of the leapfrog algorithm.  Typically called directly from \code{hmc}
}
\examples{
set.seed(321)
X <- cbind(1, rnorm(10))
y <- rnorm(10)
p <- runif(3) - 0.5
leapfrog(rep(0,3), p, 0.01, g_linear_posterior,
         diag(3), FALSE, X=X, y=y)
}
\references{
Neal, Radford. 2011. \emph{MCMC Using Hamiltonian Dynamics.} In Handbook of Markov Chain Monte Carlo, edited by Steve Brooks, Andrew Gelman, Galin L. Jones, and Xiao-Li Meng, 116–62. Chapman; Hall/CRC.
}
