% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team_dash.R
\name{nba_teamdashptshots}
\alias{nba_teamdashptshots}
\title{\strong{Get NBA Stats API Team Dashboard Player Tracking - Shots}}
\usage{
nba_teamdashptshots(
  date_from = "",
  date_to = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  per_mode = "Totals",
  period = 0,
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  team_id = "1610612749",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{per_mode}{per_mode}

\item{period}{period}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: ClosestDefender10ftPlusShooting,
ClosestDefenderShooting, DribbleShooting, GeneralShooting, ShotClockShooting,
TouchTimeShooting

\strong{GeneralShooting}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   SHOT_TYPE \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{ShotClockShooting}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   SHOT_CLOCK_RANGE \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{DribbleShooting}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   DRIBBLE_RANGE \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{ClosestDefenderShooting}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   CLOSE_DEF_DIST_RANGE \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{ClosestDefender10ftPlusShooting}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   CLOSE_DEF_DIST_RANGE \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{TouchTimeShooting}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   SORT_ORDER \tab character \cr
   G \tab character \cr
   TOUCH_TIME_RANGE \tab character \cr
   FGA_FREQUENCY \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   EFG_PCT \tab character \cr
   FG2A_FREQUENCY \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3A_FREQUENCY \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Dashboard Player Tracking - Shots}

\strong{Get NBA Stats API Team Dashboard Player Tracking - Shots}
}
\details{
\href{https://www.nba.com/stats/team/1610612749/shots-dash}{Team Player Tracking (Second Spectrum) Stats - Shooting}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teamdashptshots(team_id = '1610612749', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdetails}()},
\code{\link{nba_teamestimatedmetrics}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamelog}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teaminfocommon}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}

Other NBA Player Tracking Functions: 
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_synergyplaytypes}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Tracking Functions}
\concept{NBA Team Functions}
