% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bspline}
\alias{bspline}
\alias{bsplineGenerate}
\alias{bsplineEstimate}
\alias{bsplineComb}
\title{B-splines generation, estimation and combination}
\usage{
bsplineGenerate(knots, degree, is_names = TRUE)

bsplineEstimate(x, m, knots)

bsplineComb(splines, weights)
}
\arguments{
\item{knots}{sorted in ascending order numeric vector representing
knots of the spline.}

\item{degree}{positive integer representing degree of the spline.}

\item{is_names}{logical; if TRUE (default) then rows and columns of the
spline matrices will have a names. Set it to FALSE in order to get notable 
speed boost.}

\item{x}{numeric vector representing the points at which the 
spline should be estimated.}

\item{m}{numeric matrix which rows correspond to spline intervals
while columns represent variables powers. Therefore the element 
in i-th row and j-th column represents the coefficient associated with
the variable that 1) belongs to the i-th interval i.e. between i-th and
(i + 1)-th knots 2) raised to the power of (j - 1).}

\item{splines}{list being returned by the 
\code{\link[hpa]{bsplineGenerate}} function or a manually constructed
list with b-splines knots and matrices entries.}

\item{weights}{numeric vector of the same length as \code{splines}.}
}
\value{
Function \code{\link[hpa]{bsplineGenerate}} returns a list. Each
element of this list is a list containing the following
information concerning b-spline structure:
\itemize{
\item \code{knots} - knots vector of the b-spline. 
\item \code{m} - matrix representing polynomial coefficients for each
interval of the spline in the same manner as for \code{m} argument
(see this argument description above).
\item \code{ind} - index of the b-spline.}
Function \code{bsplineComb} returns a list with the following arguments:
\itemize{
\item \code{knots} - knots vector of the \code{splines}. 
\item \code{m} - linear combination of the \code{splines} matrices; 
coefficients of this linear combination are given 
via \code{weights} argument.}

Function \code{\link[hpa]{bsplineGenerate}} returns a numeric
vector of values being calculated at points \code{x} via splines with 
\code{knots} vector and matrix \code{m}.
}
\description{
Function \code{\link[hpa]{bsplineGenerate}} generates a list
of all basis splines with appropriate \code{knots} vector and \code{degree}.
Function \code{\link[hpa]{bsplineComb}} allows to get linear combinations
of these b-splines with particular \code{weights}. 
Function \code{\link[hpa]{bsplineEstimate}} estimates the spline at
points \code{x}. The structure of this spline should be provided via
\code{m} and \code{knots} arguments.
}
\details{
In contrast to \code{\link[splines]{bs}} function 
\code{\link[hpa]{bsplineGenerate}} generates a splines basis in a form
of a list containing information concerning these b-splines structure.
In order to evaluate one of these b-splines at particular points
\code{\link[hpa]{bsplineEstimate}} function should be applied.
}
\examples{
# Let's generate all b-splines of degree 3 with knots 
# vector (-2.1, 1.5, 1.5, 2.2, 3.7, 4.2, 5)
b <- bsplineGenerate(knots = c(-2.1, 1.5, 1.5, 2.2, 3.7, 4.2, 5), 
                     degree = 3)

# Get the first of these b-splines
b[[1]]

# Take a linear combination of these splines with 
# weights 1.6, -1.2 and 3.2.
b_comb <- bsplineComb(splines = b, weights = c(1.6, -1.2, 3.2))

# Estimate this spline value at points (-3, 0.7, 2.5, 3.8, 10)
b_values <- bsplineEstimate(x = c(-3, 0.7, 2.5, 3.8, 10),  
                            knots = b_comb$knots, 
                            m = b_comb$m)
\donttest{
# Visualize the spline
s <- seq(from = 0, to = 5, length = 1000)
b_values_s <- bsplineEstimate(x = s,  
                              knots = b_comb$knots, 
                              m = b_comb$m)
plot(s, b_values_s)
}
}
