% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRCumInc.R
\name{CRCumInc}
\alias{CRCumInc}
\title{Estimation of Cumulative Incidence of competing events}
\usage{
CRCumInc(
  df,
  time,
  event,
  exposed,
  entry = NULL,
  weights = NULL,
  ipwvars = NULL,
  print.attr = T
)
}
\arguments{
\item{df}{A data frame containing, at a minimum, exit, event, and exposure.}

\item{time}{Name of the column in df containing times of event or censoring.}

\item{event}{Name of the column in df containing codes for censoring (0) and event types (1-4). Analysis of more than 4 competing events is not supported by this function.}

\item{exposed}{Name of the column in df containing a binary (0/1) exposure variable for stratification.}

\item{entry}{Name of the column in df containing late entry times.}

\item{weights}{Name of the column in df containing user-supplied weights. If ipwvars is utilized, this argument is ignored.}

\item{ipwvars}{A vector of names of columns in `df` containing predictor variables for building a propensity score model for exposure and creating standardized inverse probability weights using this model. Overrides the weights argument.}

\item{print.attr}{A logical indicator for whether results should be returned in console.}
}
\value{
A data frame with the following columns:
\describe{
  \item{event}{Type of event that occurs at the given time.}
  \item{exposure}{Exposure group in which the event happens.}
  \item{time}{Time of the event.}
  \item{CIoinc_comp}{Value of the unexposed (denoted by “o”) composite cumulative incidence at the given time.}
  \item{CIxinc_comp}{Value of the exposed (denoted by “x”) composite cumulative incidence at the given time.}
  \item{CIoinc_1}{Value of the unexposed cumulative incidence of event 1 at the given time.}
  \item{CIxinc_1}{Value of the exposed cumulative incidence of event 1 at the given time.}
  \item{R_1}{Sub-hazard ratio/Cause-specific hazard ratio for event 1.}
  \item{R_2}{Sub-hazard ratio/Cause-specific hazard ratio for event 2.}
}
}
\description{
Estimation of Cumulative Incidence Functions (CIF) of competing events.

This function is based on the CIF estimated by the survival package.
}
\examples{
#data from the package
data <- hrcomprisk::dat_ckid
#Estimate the Cumulative Incidence Functions and Ratios of sHR and csHR
mydat.CIF<-CRCumInc(df=data, time=exit, event=event, exposed=b1nb0, print.attr=TRUE)
}
