% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{nav}
\alias{nav}
\title{Generate the <nav> HTML tag.}
\usage{
nav(
  ...,
  attr = NULL,
  separate = FALSE,
  collapse = "",
  formatted = html5_vars$formatted
)
}
\arguments{
\item{...}{A string or vector of content to pass to the tag.}

\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE, If TRUE, returns separate tags for each item of ...; if FALSE, returns one tag with the items of ... in the tag content.}

\item{collapse}{A string. If NULL, returns a vector the same length as ... instead of collapsing the tags into one string.}

\item{formatted}{TRUE/FALSE, if TRUE, HTML will be generated with indents and new lines for readability at the cost of performance. Controlled by setting the environment variable html5_vars$formatted <- TRUE/FALSE}
}
\value{
A HTML tag string.
}
\description{
The <nav> HTML element represents a section of a page whose purpose is to provide navigation links, either within the current document or to other documents. Common examples of navigation sections are menus, tables of contents, and indexes.
}
\details{
Learn more at \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nav}.
}
\examples{
nav(attr = list(class = "test"))
}
