% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_exposure.R
\name{county_wind}
\alias{county_wind}
\title{Hurricane exposure by wind for counties}
\usage{
county_wind(
  counties,
  start_year,
  end_year,
  wind_limit,
  wind_var = "vmax_sust",
  wind_source = "modeled"
)
}
\arguments{
\item{counties}{Character vector of the five-digit Federal Information
Processing Standard (FIPS) codes for counties for which the user wants to
determine storm exposure.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{wind_limit}{A numeric vector of length one giving the minimum
wind speed (in meters per second) or duration of winds of 20 m / s or more
(in minutes) to use in the filter. The units of this variable will depend on
the user's choice for the \code{wind_var} parameter. If the Extended Best
Tracks wind radii are used as the source of the wind data, the sustained
winds will only be available for cutpoints of 34 knots, 50 knots, and 64
knots, so these values should be used (e.g., to get all counties with winds of
34 knots or higher, you could use \code{wind_limit = 17.4}, with the limit
given as a value just below 34 knots in the units meters per second).}

\item{wind_var}{A character string giving the wind variable to use. Choices
are \code{"vmax_sust"} (maximum sustained winds; default), \code{"vmax_gust"}
(maximum gust winds), \code{"sust_dur"} (minutes of sustained winds of 20 m / s
or higher) and \code{"gust_dur"} (minutes of gust winds of 20 m / s or higher).
If the Extended Best Tracks wind radii are used as the source of wind data,
the \code{"gust_dur"} option cannot be selected.}

\item{wind_source}{A character string specifying the source to use for the winds. Options
are \code{"modeled"}, for estimates based on running a wind model from Best
Tracks data inputs, and \code{"ext_tracks"}, for estimates based on
the wind radii in the Extended Best Tracks data. See the help files for the
datasets \code{storm_winds} and \code{ext_tracks_wind} in the
\code{hurricaneexposuredata} package for more details on each of these sources
for wind estimates. For the gust wind estimates, these are based on applying
a gust factor of 1.49 to the sustained wind estimates in both wind data sources.}
}
\value{
Returns a dataframe with a row for each county-storm
   pair and with columns for:
   \itemize{
     \item{\code{storm_id}: }{Unique storm identifier with the storm name and year,
                 separated by a hyphen(e.g., "Alberto-1988",
                 "Katrina-2005")}
     \item{\code{fips}: }{County's 5-digit Federal Information Processing Standard
                 (FIPS) code}
     \item{\code{max_sust}: }{Maximum sustained wind speed (in m / s)}
     \item{\code{max_gust}: }{Maximum gust wind speed (in m / s)}
     \item{\code{sust_dur}: }{Minutes sustained wind speed was 20 m / s or higher}
     \item{\code{gust_dur}: }{Minutes gust wind speed was 20 m / s or higher (only
         returned if the modeled winds are requested using \code{wind_source})}
     \item{\code{usa_atcf_id}: }{United States Automated Tropical Cyclone Forecasting
                            storm identifier}
     \item{\code{closest_time_utc}: }{Time, in UTC, of the closest approach of the
                            storm to the county's population mean center,
                            based on storm tracks linearly interpolated to
                            15-minute increments.}
     \item{\code{storm_dist}: }{Minimum distance (in kilometers) between the storm's
                    track and the county's population mean center.}
     \item{\code{local_time}: }{Local time of the closest approach of the storm to the
                       county's population mean center, based on storm tracks
                       linearly interpolated to 15-minute increments.}
     \item{\code{closest_date}: }{Date (based on local time) of the closest
                         approach of the storm to the county's population
                         mean center.}
   }
}
\description{
This function takes a list of US counties, based on their 5-digit Federal
Information Processing Standard (FIPS) codes, boundaries on
the range of years to be considered, and thresholds for wind speed (in meters
per second) (or, alternatively, duration of winds at or above 20 m / s in minutes)
for each  county to be considered "exposed" to the
storm. Based on these inputs, the function returns a dataframe with the
subset of Atlantic basin storms meeting those criteria for each of the listed
counties.
}
\details{
For more information on how wind speeds are modeled in this data,
   see the documentation for the \code{stormwindmodel} R package.
}
\note{
Only counties in states in the eastern half of the United States can
   be processed by this function. Winds are modeled at 15-minute increments, so
   all duration estimates (\code{sust_dur} and \code{gust_dur} in the output)
   will be divisible by 15.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

county_wind(counties = c("22071", "51700"),
            start_year = 1988, end_year = 2005,
            wind_limit = 20, wind_var = "vmax_sust")
}
}
