% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_exposure.R
\name{multi_county_events}
\alias{multi_county_events}
\title{Hurricane exposure by events for communities}
\usage{
multi_county_events(communities, start_year, end_year, event_type)
}
\arguments{
\item{communities}{A dataframe with the FIPS codes for all counties within
each community. It must include columns with a column identifier
(\code{commun}) and with the FIPS codes of counties included in each
community (\code{fips}). See the example code.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{event_type}{Character string with the type of event to use to identify
county exposures. Options include \code{"flood"}, \code{"tornado"},
\code{"wind"}, and \code{"tropical_storm"}.}
}
\value{
Returns the same type dataframe as \code{county_events},
   but with storms listed by community instead of county.
}
\description{
This function takes a dataframe with multi-county communities and returns a
community-level dataframe of "exposed" storms, based on the type of the event.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

communities <- data.frame(community_name = c(rep("ny", 6), "no", "new"),
                         fips = c("36005", "36047", "36061",
                                  "36085", "36081", "36119",
                                  "22071", "51700"))
distance_df <- multi_county_events(communities = communities,
                                     start_year = 1995, end_year = 2005,
                                     event_type = "flood")
}
}
