% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppi}
\alias{ppi}
\title{A protein-protein physical interaction network (PPI network)}
\format{
An object of class \code{igraph} of length 15867.
}
\usage{
ppi
}
\description{
An igraph object containing a protein-protein physical interaction network.
}
\examples{
library(iPRISM)
data(ppi, package = "iPRISM")
\donttest{
library(igraph)
graph <- simplify(ppi)
graph_comp <- components(graph)$membership == which.max(components(graph)$csize)
graph <- induced_subgraph(graph, V(graph)[graph_comp])
plot(graph)
}

}
\keyword{datasets}
