% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_Function.R
\name{ggiSTAY_qprofile}
\alias{ggiSTAY_qprofile}
\title{ggplot2 extension for plotting stability and synchrony profiles.}
\usage{
ggiSTAY_qprofile(output)
}
\arguments{
\item{output}{the output obtained from \code{iSTAY_Single}, \code{iSTAY_Multiple} or \code{iSTAY_Hier}.}
}
\value{
For an \code{iSTAY_Single} object, this function return a figure showing the stability profile.\cr

For an \code{iSTAY_Multiple} object, it returns a figure displaying the profiles for gamma, alpha, and beta stability, as well as synchrony.\cr

For an \code{iSTAY_Hier} object, it returns a figure displaying the profiles for gamma, alpha, and beta stability, as well as synchrony.
}
\description{
\code{ggiSTAY_qprofile} is a graphical function based on the output from the function \code{iSTAY_Single}, \code{iSTAY_Multiple} or \code{iSTAY_Hier}. It generates stability (and synchrony, if multiple time series are included) profiles that depict how stability and synchrony vary with the order q > 0.
}
\examples{
data("Data_Jena_20_metacommunities")
data("Data_Jena_76_metapopulations")
data("Data_Jena_462_populations")
data("Data_Jena_hierarchical_structure")

## Single time series analysis
# Plot the stability profiles of two selected plots
# See Example 1 in the iSTAY vignette for the output.

individual_plots <- do.call(rbind, Data_Jena_20_metacommunities)
output_two_plots_q <- iSTAY_Single(
               data = individual_plots[which(rownames(individual_plots) 
               \%in\% c("B1_4.B1A04", "B4_2.B4A14")),],
               order.q = seq(0.1,2,0.1), Alltime = TRUE)
ggiSTAY_qprofile(output = output_two_plots_q)

# Plot the stability profiles of two selected populations
# See Example 3 in the iSTAY vignette for the output.
individual_populations <- do.call(rbind, Data_Jena_76_metapopulations)
output_two_populations_q <- iSTAY_Single(
               data = individual_populations[which(rownames(individual_populations) 
               \%in\% c("B1A06_B1_16.BM_Ant.odo", "B1A06_B1_16.BM_Cam.pat")),],
               order.q = seq(0.1,2,0.1), Alltime = TRUE)
ggiSTAY_qprofile(output = output_two_populations_q)


## Multiple time series analysis
# Plot the gamma, alpha and beta stability profiles, 
# as well as synchrony profiles for two selected metacommunities
# See Example 5 in the iSTAY vignette for the output.

metacommunities <- Data_Jena_20_metacommunities
output_two_metacommunities_q <- iSTAY_Multiple(
           data = metacommunities[which(names(metacommunities) \%in\% c("B1_1",  "B3_2"))],
           order.q = seq(0.1,2,0.1), Alltime = TRUE)
ggiSTAY_qprofile(output = output_two_metacommunities_q)

# Plot the gamma, alpha and beta stability profiles, 
# as well as synchrony profiles of two selected metapopulations
# See Example 7 in the iSTAY vignette for the output.

metapopulations <- Data_Jena_76_metapopulations
output_two_metapopulations_q <- iSTAY_Multiple(
           data = metapopulations[which(names(metapopulations) \%in\% c("B1A04_B1_4", "B4A14_B4_2"))],
           order.q = seq(0.1,2,0.1), Alltime = TRUE)
ggiSTAY_qprofile(output = output_two_metapopulations_q)


## Hierarchical time series analysis
# See Example 9 in the iSTAY vignette for the output.
output_hier_q <- iSTAY_Hier(data = Data_Jena_462_populations,
                           structure = Data_Jena_hierarchical_structure,
                           order.q = seq(0.1,2,0.1), Alltime = TRUE)
ggiSTAY_qprofile(output = output_hier_q)

}
