% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_ibd.R
\name{d_ibd}
\alias{d_ibd}
\title{Compute probability of IBD for pedigree members}
\usage{
d_ibd(
  ibd,
  pedigree,
  ids = pedtools::leaves(pedigree),
  recombination_rate_by_locus = numeric(),
  states = "ibd",
  log10 = FALSE
)
}
\arguments{
\item{ibd}{Integer vector. Taking values 0, 1, 2 for \code{states = "ibd"} or \code{states = "kappa"}, 1, ..., 9 for \code{states="identity"} and 1, ..., 15 for \code{states = "detailed"}.}

\item{pedigree}{Pedigree in \code{\link[pedtools:ped]{pedtools::ped}} form.}

\item{ids}{Ids for which IBD is observed. Defaults to \code{\link[pedtools:ped_subgroups]{pedtools::leaves}}\code{(pedigree)}.}

\item{recombination_rate_by_locus}{Numeric vector with length one shorter than \code{ibd}.}

\item{states}{One of \code{"ibd"} (default), \code{"kappa"}, \code{"identity"} or \code{"detailed"}.}

\item{log10}{Should the log10 likelihood be returned? Default is \code{FALSE}.}
}
\value{
Numeric
}
\description{
The \code{d_ibd} function computes the likelihood of IBD
for one position or multiple linked markers on the same chromosome.
}
\examples{
# Compute kappa0, kappa1, kappa2 for full siblings
ped_fs <- pedtools::nuclearPed(nch = 2)

k0 <- d_ibd(ibd = 0, pedigree = ped_fs)
k1 <- d_ibd(ibd = 1, pedigree = ped_fs)
k2 <- d_ibd(ibd = 2, pedigree = ped_fs)
c(k0, k1, k2)

stopifnot(identical(c(k0, k1, k2), c(0.25, 0.5, 0.25)))

# Compute kappa00 for two tightly linked loci
d_ibd(c(0,0), pedigree = ped_fs,
       recombination_rate_by_locus = c(0.01))

# or 100 tightly linked loci
d_ibd(rep(0, 100), pedigree = ped_fs,
               recombination_rate_by_locus = c(rep(0.01, 99)))

# Jacquard's 9 condensed and 15 detailed identity coefficients
ped_fs_mating <- pedtools::fullSibMating(1)

sapply(1:9, d_ibd, pedigree = ped_fs_mating, states = "identity")
sapply(1:15, d_ibd, pedigree = ped_fs_mating, states = "detailed")
}
