% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_trans.R
\name{state_trans}
\alias{state_trans}
\title{Make state transitions.}
\usage{
state_trans(origin, new.states, params, s.matrix)
}
\arguments{
\item{origin}{A number which represents the column index \code{s.matrix} you want to do the transition from}

\item{new.states}{A numeric vector or a number which represents the column index \code{s.matrix} you want
as the destination(s) for the transition}

\item{params}{A numeric vector of similar length to \code{new.states} which serves as the transition rate(s)}

\item{s.matrix}{A state matrix created from \code{syn_pop} function}
}
\value{
A transition matrix of the same dimension as \code{s.matrix}. -1 indicates that the individual has left
    the corresponding state. +1 indicates that the individual has become the corresponding state.
}
\description{
Take in the matrix of the states of synthetic population (created by \code{syn_pop} function)
and calculate the transitions from one state to other state(s) using the transition rate(s).
}
\examples{
pop <- syn_pop(c(19,1,0,0))
state_trans(1,2,.1,pop)
state_trans(1,4,100,pop)

}

