% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-graphs.R, R/data-facelayer-graphs.R
\name{holes}
\alias{holes}
\alias{holes,trigrid-method}
\alias{holes,facelayer-method}
\title{Holes of shapes on an icosahedral grid}
\usage{
holes(x, ...)

\S4method{holes}{trigrid}(x, y, outside = FALSE)

\S4method{holes}{facelayer}(x)
}
\arguments{
\item{x}{(\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}}) An icosahedral grid or associated facelayer object.}

\item{...}{Arguments passed to class-specific methods.}

\item{y}{(\code{character}) Horizontal shapes defined as a character vector of face names.}

\item{outside}{(\code{logical}) Should the set of faces that are outside the shape be returned as well?}
}
\value{
A named numeric vector, names correspond to faces, numbers outline the holes. If \code{outside=FALSE} and there are no holes in the shape, the function will return \code{NULL}.
}
\description{
The function calculates the face names that represent holes in a surface shape
}
\details{
The function uses the horizontal graph of a \code{\link{trigrid}}-class object, removes the subgraph corresponding to a set of faces (the shape),
and searches for isolated subgraphs. The largest subgraph (highest number of vertices, i.e. faces)  is considered to be outside of the shape.
This function relies on the \code{igraph} package to run.
}
\examples{

# create a grid
hex <- hexagrid(2, sf=TRUE)
# an example shape
shape <- paste0("F", c(4, 5, 11, 13, 15, 21, 24, 26, 32, 33, 34, 35, 36))

# visualize basic grid
plot(hex)
gridlabs(hex)

# visualize the shape
plot(hex, shape, col="#FF000055", add=TRUE)

# calculate holes
ho <- holes(x=hex, y=shape)

# plot both holes
plot(hex, names(ho[ho==1]), add=TRUE, col="#00FF0055")
plot(hex, names(ho[ho==2]), add=TRUE, col="#0000FF55")
}
