% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icfit.R
\name{icfit}
\alias{icfit}
\title{Fit a proportional hazards model with baseline hazard modeled by P-splines}
\usage{
icfit(
  formula,
  data,
  entry,
  lambda = 10,
  nt = 100,
  tmax,
  nseg = 20,
  bdeg = 3,
  pord = 2,
  nit = 50,
  tol = 1e-06,
  tollam = 0.01,
  kappa = 1e-06,
  update_lambda = TRUE,
  ic_update = TRUE,
  monitor = FALSE
)
}
\arguments{
\item{formula}{A formula object with response of the left of a ~ operator
and covariate terms on the right. The response must be a survival object
as returned by the `Surv` function, with type either right', 'counting' or
'interval2'}

\item{data}{A data frame in which to interpret the variable names in the
`formula`}

\item{entry}{When appropriate, a vector of entry (left truncation) times,
or a string indicating the column name in `data` containing entry times;
only used if Surv object is of type 'interval2'}

\item{lambda}{Starting value of penalty tuning parameter}

\item{nt}{The number of time bins}

\item{tmax}{The end of time domain (default 1.01 times largest observation)}

\item{nseg}{The number of B-spline segments}

\item{bdeg}{The degree of the B-splines}

\item{pord}{The order of the differences used in the penalty}

\item{nit}{Maximum number of iterations (integer)}

\item{tol}{Tolerance for final fit}

\item{tollam}{Tolerance for switching to lambda update}

\item{kappa}{Ridge parameter (number)}

\item{update_lambda}{Automatic update of lambda (Boolean)}

\item{ic_update}{Update risk and event probabilities (Boolean)}

\item{monitor}{Monitor convergence (Boolean)}
}
\value{
An object of class `icfit`
}
\description{
Fit a proportional hazards model with baseline hazard modeled by P-splines
}
\examples{
# Fit proportional hazards model to interval-censored data
icfit(Surv(left, right, type='interval2') ~ period + gender + age,
      data=drugusers)
# Fit proportional hazards model to right-censored data
icfit(Surv(time, d) ~ Diameter + FIGO + Karnofsky, data = Ova)

}
