% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Generate a discrete IC object}
\usage{
init(Times, X, nt, tmax, nseg = 20, bdeg = 3, pord = 2, kappa = 1e-06)
}
\arguments{
\item{Times}{The (possibly interval censored) survival data, in a matrix}

\item{X}{The design matrix containing covariates}

\item{nt}{The number of bins for discretization}

\item{tmax}{The end of time domain (default 1.01 times largest observation)}

\item{nseg}{The number of B-spline segments}

\item{bdeg}{The degree of the B-splines}

\item{pord}{The order of the differences used in the penalty}

\item{kappa}{Ridge parameter (number)}
}
\value{
A list with items
\item{data}{List containing the original data as well as the binned data}
\item{bins}{List with information on bins used}
\item{basis}{List containing the B-spline matrix}
\item{start}{List containing information on starting values}
\item{penalty}{List containing Pdiff and Pridge}
\item{control}{List with information on control of B-spline basis}
}
\description{
Generate a discrete IC object
}
