% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEA.R
\name{SeqCEA}
\alias{SeqCEA}
\title{Sequential Coordinate Exchange algorithm for MNL model.}
\usage{
SeqCEA(
  des = NULL,
  lvls,
  coding,
  c.lvls = NULL,
  n.alts,
  par.draws,
  prior.covar,
  alt.cte = NULL,
  no.choice = NULL,
  weights = NULL,
  parallel = TRUE,
  reduce = TRUE,
  n.cs = NULL
)
}
\arguments{
\item{des}{A design matrix in which each row is a profile. If alternative
specific constants are present, those should be included as the first
column(s) of the design. Can be generated with \code{\link{Modfed}} or
\code{\link{CEA}}}

\item{lvls}{A numeric vector which contains for each attribute the number
of levels.}

\item{coding}{Type of coding that needs to be used for each attribute.}

\item{c.lvls}{A list containing numeric vectors with the attribute levels for
each continuous attribute. The default is \code{NULL}.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{par.draws}{A matrix or a list, depending on \code{alt.cte}.}

\item{prior.covar}{Covariance matrix of the prior distribution.}

\item{alt.cte}{A binary vector indicating for each alternative whether an
alternative specific constant is desired. The default is \code{NULL}.}

\item{no.choice}{An integer indicating the no choice alternative. The default
is \code{NULL}.}

\item{weights}{A vector containing the weights of the draws. Default is
\code{NULL}. See also \code{\link{ImpsampMNL}}.}

\item{parallel}{Logical value indicating whether computations should be done
over multiple cores.}

\item{reduce}{Logical value indicating whether the candidate set should be
reduced or not.}

\item{n.cs}{An integer indicating the number of possible random choice sets to
consider in the search for the next best choice set possible. The default is
\code{NULL}.}
}
\value{
\item{set}{A matrix representing a DB efficient choice set.}
\item{error}{A numeric value indicating the DB-error of the whole
design.}
}
\description{
Selects the choice set that minimizes the DB-error when added to an initial
design, given (updated) parameter values.
}
\details{
This algorithm is ideally used in an adaptive context. The algorithm will
select the next DB-efficient choice set given parameter values and possible
previously generated choice sets. In an adaptive context these parameter
values are updated after each observed response.

Previously generated choice sets, which together form an initial design, can
be provided in \code{des}. When no design is provided, the algorithm will
select the most efficient choice set based on the fisher information of the
prior covariance matrix \code{prior.covar}.

If \code{alt.cte = NULL}, \code{par.draws} should be a matrix in which each
row is a sample from the multivariate parameter distribution. In case that
\code{alt.cte} is not \code{NULL}, a list containing two matrices should be
provided to \code{par.draws}. The first matrix containing the parameter draws
for the alternative specific parameters. The second matrix containing the
draws for the rest of the parameters.

The list of potential choice sets is created by selecting randomly a level for
each attribute in an alternative/profile. \code{n.cs} controls the number of
potential choice sets to consider. The default is \code{
NULL}, which means that the number of possible choice sets is the product of
attribute levels considered in the experiment. For instance, an experiment
with 3 attribute and 3 levels each will consider 3^3 = 27 possible choice sets.

The \code{weights} argument can be used when the \code{par.draws} have
weights. This is for example the case when parameter values are updated using
\code{\link{ImpsampMNL}}.

When \code{parallel} is \code{TRUE}, \code{\link[parallel]{detectCores}} will
be used to decide upon the number of available cores. That number minus 1
cores will be used to search for the optimal choice set. For small problems
(6 parameters), \code{parallel = TRUE} can be slower. For larger problems the
computation time will decrease significantly.

\emph{Note:} this function is faster than \code{\link[idefix]{SeqMOD}}, but
the output is not as stable. This happens because this function
makes a random search to get the choice set, whereas
\code{\link[idefix]{SeqMOD}} makes an exhaustive search.
}
\examples{
# DB efficient choice set, given a design and parameter draws. 
# 3 attributes with 3 levels each
m <- c(0.3, 0.2, -0.3, -0.2, 1.1, 2.4) # mean (total = 6 parameters).
pc <- diag(length(m)) # covariance matrix
set.seed(123)
sample <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc)
# Initial design.
des <- example_design
# Efficient choice set to add.
SeqCEA(des = des, lvls = c(3, 3, 3), coding = c("D", "D", "D"), n.alts = 2,
       par.draws = sample, prior.covar = pc, parallel = FALSE)

# DB efficient choice set, given parameter draws. 
# with alternative specific constants 
des <- example_design2
ac <- c(1, 1, 0) # Alternative specific constants.
m <- c(0.3, 0.2, -0.3, -0.2, 1.1, 2.4, 1.8, 1.2) # mean
pc <- diag(length(m)) # covariance matrix
pos <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc)
sample <- list(pos[ , 1:2], pos[ , 3:8])
# Efficient choice set.
SeqCEA(des = des, lvls = c(3, 3, 3), coding = c("D", "D", "D"), n.alts = 3, 
      par.draws = sample, alt.cte = ac, prior.covar = pc, parallel = FALSE)
}
\references{
\insertRef{idefix}{idefix}

\insertRef{ju}{idefix}

\insertRef{cea}{idefix}

\insertRef{cea_discrete}{idefix}
}
