% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handD-data.R
\docType{data}
\name{handD}
\alias{handD}
\title{Hand ratation data}
\format{
An object of class \code{'dist'}.
}
\usage{
data(handD)
}
\description{
Data from a QTL experiment on gravitropism in
Arabidopsis, with data on 162 recombinant inbred lines (Ler x
Cvi). The outcome is the root tip angle (in degrees) at two-minute
increments over eight hours.
}
\examples{
data(handD)
estmle <- lbmle(x=handD,DM=TRUE,k1=5,k2=10)
print(estmle)
}
\references{
E. Levina and P. J. Bickel. Maximum likelihood estimation of intrinsic dimension. Advances in Neural Information Processing Systems 17, 2005.

B. Kegl. Intrinsic dimension estimation using packing numbers. Advances in Neural Information Processing Systems 15, 2002.

H. Hino, J. Fujiki, S. Akaho, and N. Murata, 'Local Intrinsic Dimension Estimation by Generalized Linear Modeling', Neural Computation, 2017
}
\keyword{datasets}
