% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.idiffomix.R
\name{plot.idiffomix}
\alias{plot.idiffomix}
\title{Plots for visualizing the idiffomix class object}
\usage{
\method{plot}{idiffomix}(
  x,
  what = "chromosome",
  CHR = 1,
  Gene = NULL,
  K = 3,
  L = 3,
  gene_cluster_name = c("E-", "E0", "E+"),
  cpg_cluster_name = c("M-", "M0", "M+"),
  ...
)
}
\arguments{
\item{x}{A \code{\link[idiffomix:idiffomix]{idiffomix}} object.}

\item{what}{The different plots that can be obtained are either "chromosome" or "gene" (default = "chromosome").}

\item{CHR}{The chromosome number to be visualized (default = 1).}

\item{Gene}{The name of the gene to be visualized (default = NULL).}

\item{K}{Number of clusters for expression data (default = 3; E-,E0,E+).}

\item{L}{Number of clusters for methylation data (default = 3; M-,M0,M+).}

\item{gene_cluster_name}{The names to be given to the clusters for identification (default = c( "E-","E0","E+")).}

\item{cpg_cluster_name}{The names to be given to the clusters for identification (default = c( "M-","M0","M+")).}

\item{...}{Other graphics parameters.}
}
\value{
This function displays the following plots as requested by the user:
\itemize{
\item chromosome plot - Plot showing the conditional probabilities estimated when the joint mixture model is applied to data from a chromosome.
\item gene plot - Plot showing the log-fold changes and differences in M-values and the estimated posterior probability of the gene belonging to the K clusters.
}
}
\description{
Visualise a \code{\link[idiffomix:idiffomix]{idiffomix}} clustering solution by plotting the conditional probabilities estimated for genes and CpG sites (A) per chromosome and (B) for a gene and its corresponding CpG sites.
}
\details{
The function displays two plots. The first plot displays the conditional probabilities estimated when the joint mixture model is applied to data from a chromosome.
Panel A displays the probability of a gene in the chromosome belonging to each of the K clusters.
Panel B details the estimated matrix pi of conditional probabilities of a CpG site's cluster membership, given its gene's cluster.
Panel C details the conditional probabilities of a gene belonging to cluster $k$ given a single CpG site associated with the gene belongs to cluster $l$, computed using Bayes' theorem,
given tau and pi. The second plot displays the log-fold changes and differences in M-values and the estimated posterior probability of the gene belonging to the K clusters.
Panel A shows the log-fold change and difference in M-values for the given gene and its associated CpG sites while Panel B shows the posterior probabilities of cluster membership for the gene under idiffomix.
}
\examples{
N <- 4
data_transformed = data_transformation(seq_data=gene_expression_data,
                                  meth_data=methylation_data,
                                  gene_chr=gene_chromosome_data,
                                  N=N)
data_output = idiffomix(seq_data=data_transformed$seq_transformed,
                        meth_data=data_transformed$meth_transformed,
                        gene_chr=gene_chromosome_data,
                        N=N, K=3, L=3, probs=c(0.25,0.75),
                        parallel_process = FALSE)
plot(data_output,what="chromosome",CHR=1, Gene=NULL,K=3,L=3,
     gene_cluster_name=c( "E-","E0","E+"),
     cpg_cluster_name=c( "M-","M0","M+"),
     title=NULL)

}
\seealso{
\code{\link{idiffomix}}
}
