#include <RcppArmadillo.h>
#include "ieTest.h"
using namespace Rcpp;

// Function that accepts cumulative probabilities for the two terms that comprise
// the product of the indirect effect - the effect of the independent variable
// on the mediator, and the effect of the mediator and the interaction of the 
// mediator and independent variable on the response. 

//' Is the mediation effect significant?
//'
//' This function takes 2 U values for the asq-test for either one
//' mediator of one path of an unordered mediation scenario,
//'  as well as an alpha level. It returns whether the
//' test would reject at the given alpha level. Additionally,
//' the cutoff, either specified by number of squares or the 
//' percentage towards the center of the transformation region, 
//' can be specified.
//' This function is primarily called by the asq_one function
//' to determine if the test is significant at one of a chosen
//' set of alpha values. 
//'
//' @param alpha Significance level for the test.
//' @param u1,u2 The U values to be used in the test
//' @param numSquares The number of squares to be used in the asq-test. Always superceded by upLim
//' @param upLim The allowed extension, between 0 and 1, of the squares towards the center of the region
//' @returns A boolean variable indicating if the indirect effect null hypothesis is rejected.
//' @export
//' @examples
//' asq_one_bool(.05, .02, .015, .995, upLim = .75)
bool asq_one_bool(double alpha, double u1, double u2, 
                  long int numSquares = 4, double upLim = 0.5){
// If upper limit is too large (greater than 100%), lower to max.
  if(upLim > 1.0){
    Rcout << "Upper Limit too large. Running with Upper Limit set at 1\n";
    upLim = 1.0;
  }
  // If upLim specified, set numSquares off of that;
  if(upLim > 0){
    numSquares = floor(upLim / alpha);
  }
  
  // Forces u1 and u2 to be less than .5 (in lower left quarter of transformation region)
  u1 = std::min(u1, 1 - u1);
  u2 = std::min(u2, 1 - u2);
  
  long double u1Square = floor( u1 / (alpha/2.0));
  long double u2Square = floor( u2 / (alpha/2.0));

  return((u1Square == u2Square) & (u1Square < numSquares));
}
