% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5.R
\name{io_write_h5}
\alias{io_write_h5}
\title{Save objects to 'HDF5' file without trivial checks}
\usage{
io_write_h5(
  x,
  file,
  name,
  chunk = "auto",
  level = 4,
  replace = TRUE,
  new_file = FALSE,
  ctype = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{an array, a matrix, or a vector}

\item{file}{path to 'HDF5' file}

\item{name}{path/name of the data; for example, \code{"group/data_name"}}

\item{chunk}{chunk size}

\item{level}{compress level from 0 - no compression to 10 - max compression}

\item{replace}{should data be replaced if exists}

\item{new_file}{should removing the file if old one exists}

\item{ctype}{data type such as "character", "integer", or "numeric". If
set to \code{NULL} then automatically detect types. Note for complex data
please store separately the real and imaginary parts.}

\item{quiet}{whether to suppress messages, default is false}

\item{...}{passed to other \code{LazyH5$save}}
}
\value{
Absolute path of the file saved
}
\description{
Save objects to 'HDF5' file without trivial checks
}
\examples{

file <- tempfile()
x <- array(1:120, dim = 2:5)

# save x to file with name /group/dataset/1
io_write_h5(x, file, '/group/dataset/1', chunk = dim(x))

# load data
y <- io_read_h5(file, '/group/dataset/1')

# read data to memory
y[]

# clean up
unlink(file)

}
\seealso{
\code{\link{io_read_h5}}
}
