% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canny_edges_detector.R
\name{image_canny_edge_detector}
\alias{image_canny_edge_detector}
\title{Canny Edge Detector for Images}
\usage{
image_canny_edge_detector(x, s = 2, low_thr = 3, high_thr = 10, accGrad = TRUE)
}
\arguments{
\item{x}{a matrix of image pixel values in the 0-255 range.}

\item{s}{sigma, the Gaussian filter variance. Defaults to 2.}

\item{low_thr}{lower threshold value of the algorithm. Defaults to 3.}

\item{high_thr}{upper threshold value of the algorithm. Defaults to 10}

\item{accGrad}{logical indicating to trigger higher-order gradient}
}
\value{
a list with element edges which is a matrix with values 0 or 255 indicating
in the same dimension of \code{x}. Next to that
the list also contains the input parameters s, low_thr, high_thr and accGrad,
the number of rows (nx) and columns of the image (ny) and the number of pixels which
have value 255 (pixels_nonzero).
}
\description{
Canny Edge Detector for Images. See \url{https://en.wikipedia.org/wiki/Canny_edge_detector}.
Adapted from \url{https://github.com/Neseb/canny}.
}
\examples{
if(requireNamespace("pixmap")){

library(pixmap)
imagelocation <- system.file("extdata", "chairs.pgm", package="image.CannyEdges")
image <- read.pnm(file = imagelocation, cellres = 1)
x <- image@grey * 255

edges <- image_canny_edge_detector(x)
edges
plot(edges)

}

\donttest{
if(requireNamespace("magick")){
##
## image_canny_edge_detector expects a matrix as input
##  if you have a jpg/png/... convert it to pgm first or take the r/g/b channel
library(magick)
x <- image_read(system.file("extdata", "atomium.jpg", package="image.CannyEdges"))
x
image <- image_data(x, channels = "Gray")
image <- as.integer(image, transpose = TRUE)
edges <- image_canny_edge_detector(image)
edges
plot(edges)
}

if(requireNamespace("pixmap") && requireNamespace("magick")){
##
## image_canny_edge_detector expects a matrix as input
##  if you have a jpg/png/... convert it to pgm first or take the r/g/b channel
library(magick)
library(pixmap)
f <- tempfile(fileext = ".pgm")
x <- image_read(system.file("extdata", "atomium.jpg", package="image.CannyEdges"))
x <- image_convert(x, format = "pgm", depth = 8)
image_write(x, path = f, format = "pgm")

image <- read.pnm(f, cellres = 1)
edges <- image_canny_edge_detector(image@grey * 255)
edges
plot(edges)

file.remove(f)
}
}
}
