% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagesToKerasInput.R
\name{imagesToKerasInput}
\alias{imagesToKerasInput}
\title{Convert magick images in tibble to array for keras}
\usage{
imagesToKerasInput(
  images,
  subset = NULL,
  type = NULL,
  grayscale = NULL,
  n_class = 1,
  max = 1
)
}
\arguments{
\item{images}{list. Output of \code{loadImages} or \code{dataAugmentation}. List with two items ($info: data frame with information about images, $img: tibble containing magick images)}

\item{subset}{integer. Indices of images to process. Can be useful for only processing subsets of images (e.g. training images, not test/validation images).}

\item{type}{character. Can be "image" or "mask" and will set color channels of array accordingly (optional).}

\item{grayscale}{logical. Defines color channels of images: 1 if code{TRUE}, 3 if \code{FALSE}.}

\item{n_class}{For mask images, how many classes do they contain? (note that binary classifications like the canopy model have one class only)}

\item{max}{integer. Maximum value of output color values range. Can be 1 or 255.}
}
\value{
An array with the following dimensions: image, height, width, channels
}
\description{
This function converts a tibble of images into input for TensorFlow models in keras. Specifically, images are converted to 4D arrays (image, height, width, channels). It can process color images and masks (for model training).
}
\details{
The function will try to infer the colorspace from images, but if the colorspaces are inconsistent one has to define 'colorspace'.
\code{type = "image"} can have either colorspace "sRGB" or "Gray", masks are always "Gray". color images have three color channels in the arrays, grayscale images have one color channel.
\code{n_class} is only relevant for masks. It determines the dimensions of the output. The default 1 is the (binary case). Higher values are for multi-class cases. If n_class is 2 or larger, keras::to_categorical() will be applied, and the \code{\link{u_net}} model will use softmax instead of sigmoid activation in the final layer.

By default, color value range will be 0-1. Alternatively, set \code{max} to 255 to create color value range 0-255 (e.g. to create input for Habitat-Net models).
}
\examples{
# Example 1: Canopy

# images
wd_images_can <- system.file("images/canopy/resized",
                             package = "imageseg")
images_can <- loadImages(imageDir = wd_images_can)
x <- imagesToKerasInput(images_can)
str(x)   # a 4D array with an attribute data frame

# masks

wd_mask_can <- system.file("images/canopy/masks",
                             package = "imageseg")
masks_can <- loadImages(imageDir = wd_mask_can)
y <- imagesToKerasInput(masks_can, type = "mask", grayscale = TRUE)
str(y)   # a 4D array with an attribute data frame

# Example 2: Understory
wd_images_us <- system.file("images/understory/resized",
                             package = "imageseg")
images_us <- loadImages(imageDir = wd_images_us)
x <- imagesToKerasInput(images_us)
str(x)   # a 4D array, with an attribute data frame

}
