% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadImages.R
\name{loadImages}
\alias{loadImages}
\title{Load image files with magick}
\usage{
loadImages(
  imageDir,
  fileNames,
  pattern,
  patternInclude = TRUE,
  imageFormats = c("JPG|TIF|PNG|JPEG|TIFF")
)
}
\arguments{
\item{imageDir}{character. Directory containing the images to load}

\item{fileNames}{character. File names to load (they will still be filtered by \code{pattern}, if defined)}

\item{pattern}{character. Pattern to search in file names}

\item{patternInclude}{logical. Include images with pattern in file names (TRUE) or exclude (FALSE)}

\item{imageFormats}{character. Image file formats to read.}
}
\value{
A list with 2 slots: "img" contains images as a tibble, "info" contains basic information about the images.
}
\description{
This function loads images from disk to R, where one can inspect them and then pass them on to \code{\link{imagesToKerasInput}}, which converts them to input for keras (TensorFlow) models.
}
\examples{
# Example 1: Canopy
wd_images_can <- system.file("images/canopy/resized",
                             package = "imageseg")

images_can <- loadImages(imageDir = wd_images_can)
images_can

# Example 2: Understory
wd_images_us <- system.file("images/understory/resized",
                             package = "imageseg")
images_us <- loadImages(imageDir = wd_images_us)
images_us

}
