% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_donor.R
\name{model_donor}
\alias{model_donor}
\title{Model for donor-based imputation}
\usage{
model_donor(ds, M = is.na(ds), i = NULL, model_arg = NULL)
}
\arguments{
\item{ds}{The data set to be imputed. Must be a data frame with column names.}

\item{M}{Missing data indicator matrix}

\item{i}{Index for row of \code{ds} or \code{NULL}}

\item{model_arg}{A list with two named elements (missing elements will be
replaced by default values):
\itemize{
\item \code{selection} How to select the donors? Possible choices are:
\code{complete_rows} (default), \code{partly_complete_rows}, \code{knn_complete_rows},
\code{knn_partly_complete_rows}
\item \code{k} number of selected closest donor (default: 10), only used for knn
\code{selection}s
}}
}
\value{
A "model" for \code{\link[=predict_donor]{predict_donor()}} which is merely a data frame.
}
\description{
This function is intended to be used inside of \code{\link[=impute_unsupervised]{impute_unsupervised()}} as
\code{model_fun}.
}
\examples{
set.seed(123)
ds_mis <- data.frame(X = rnorm(10), Y = rnorm(10))
ds_mis[2:4, 1] <- NA
ds_mis[4:6, 2] <- NA
# default returns only complete rows
model_donor(ds_mis)
# with partly_complete and knn returned objects depends on i
model_donor(ds_mis,
  i = 2,
  model_arg = list(selection = "partly_complete_rows")
)
model_donor(ds_mis,
  i = 4,
  model_arg = list(selection = "partly_complete_rows")
)
model_donor(ds_mis,
  i = 5,
  model_arg = list(selection = "partly_complete_rows")
)
model_donor(ds_mis,
  i = 5,
  model_arg = list(selection = "knn_partly_complete_rows", k = 2)
)
}
\seealso{
\code{\link[=predict_donor]{predict_donor()}}
}
