% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicit_functions.R
\name{saveRecord}
\alias{saveRecord}
\title{Function to save elicitation record.}
\usage{
saveRecord(
  designLink.obj,
  conclusion.comments = "This concludes the elicitation record.",
  file = ""
)
}
\arguments{
\item{designLink.obj}{list object initally created by function \code{\link{designLink}} 
and subsequently updated by function \code{\link{elicitPt}}}

\item{conclusion.comments}{character, comments to conclude session. Beware of
non-ASCII text and special characters, which may affect ability to save or
generate a \code{Sweave} document by using \code{\link{makeSweave}}}

\item{file}{character providing filename.}
}
\value{
an RDS file is created with filename \code{file}. A timestamp is
  added to \code{designLink.obj} using \code{Sys.time()}.
}
\description{
Function to save elicitation record.
}
\examples{
\dontrun{
X <- matrix(c(1, 1, 0, 1), nrow = 2) # design
Z <- designLink(design = X)
tmp <- tempfile(pattern = "report", fileext =".rds")
saveRecord(Z, file = tmp)
}
}
