% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_covid_stats_by_country_name.R
\name{get_covid_stats_by_country_name}
\alias{get_covid_stats_by_country_name}
\title{Get COVID-19 Statistics for a Specific Country}
\usage{
get_covid_stats_by_country_name(
  country,
  yesterday = FALSE,
  twoDaysAgo = FALSE,
  strict = TRUE,
  allowNull = FALSE
)
}
\arguments{
\item{country}{Character. A country name, ISO2, ISO3 code, or country ID.}

\item{yesterday}{Logical. If \code{TRUE}, gets data reported from the previous day. Default is \code{FALSE}.}

\item{twoDaysAgo}{Logical. If \code{TRUE}, gets data reported two days ago. Default is \code{FALSE}.}

\item{strict}{Logical. If \code{TRUE} (default), disables fuzzy matching (e.g., avoids confusion between "Oman" and "Romania").}

\item{allowNull}{Logical. If \code{TRUE}, allows null values (returned as \code{NA}). Default is \code{FALSE}.}
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{country}: Country name.
  \item \code{updated}: Timestamp of last update (POSIXct in UTC).
  \item \code{cases}: Total confirmed cases.
  \item \code{todayCases}: New confirmed cases today.
  \item \code{deaths}: Total deaths.
  \item \code{recovered}: Total recoveries.
  \item \code{population}: Estimated population.
}
Returns \code{NULL} if the API is unavailable, the country is not found, or an error occurs.
}
\description{
Retrieves COVID-19 totals for a given country using the 'disease.sh' API.
}
\details{
This function accesses COVID-19 data for a specific country based on its name or ISO code.
Requires an active internet connection.
}
\note{
Requires internet connection. Function fails gracefully if API is unavailable.
}
\examples{
\dontrun{
# Get data for Brazil
brazil_data <- get_covid_stats_by_country_name("Brazil")
if (!is.null(brazil_data)) {
  print(brazil_data)
}

# Get data for the USA using ISO2 code
usa_data <- get_covid_stats_by_country_name("US", yesterday = TRUE)
}

}
\references{
API Docs: https://disease.sh/docs/#/COVID-19%3A%20Worldometers/get_v3_covid_19_countries__country_
}
