% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_default.R
\name{extended-null-default}
\alias{extended-null-default}
\alias{\%|||\%}
\title{Expanded default operator}
\usage{
lhs \%|||\% rhs
}
\arguments{
\item{lhs}{The left-hand side, the value(s) to be evaluated
as.}

\item{rhs}{The right-hand side, the value(s) to be returned
if \code{lhs} evaluates as one of the covered values.}
}
\value{
An atomic value or vector the same length as the left-hand
side input.
}
\description{
The \verb{\%||\%} operator will return a default value,
defined by the right-hand object, if the left-hand value
resolves as \code{NULL}. However, there may be times when users
want more than just \code{NULL} values to return the default but,
also, values that are \code{NA}, \code{FALSE}, and those that are
length 0 (such as \code{character(0)} or \code{integer(0)}).
}
\details{
The expanded default operator covers the following cases:
\itemize{
\item \code{NULL}
\item An atomic \code{FALSE}
\item A vector where all values are \code{FALSE}
\item An atomic \code{NA}
\item A vector where all values are \code{NA}
\item An object of length 0.
}

Users have the ability to add additional tests via
\code{options(infixit.extended_default_tests)}. Users can change
the current list---including by adding the name of a testing
function (i.e., one that returns a Boolean value) that is
currently defined in an environment accessible to the function
(e.g., in the global environment).
}
\examples{
{
  NULL \%|||\% 'fizzbuzz' #returns fizzbuzz
  FALSE \%|||\% 'fizzbuzz' #also returns fizzbuzz
  NA \%|||\% 'fizzbuzz' #still returns fizzbuzz
  'test' \%|||\% 'fizzbuzz'#returns 'test'
}


}
