% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter.R
\name{pinpoint}
\alias{pinpoint}
\title{Determine Identified Influential Cases}
\usage{
pinpoint(inf_list, local_list)
}
\arguments{
\item{inf_list}{An IAUC class object}

\item{local_list}{An LAUC class object}
}
\description{
Provide either mutually identified influential cases through IAUC and LAUC or compare with cumulative lift charts to determine which theoretical approach is more appropriate.
}
\examples{

library(ROCR)
data("ROCR.simple")
Ioutput <- IAUC(ROCR.simple$predictions, ROCR.simple$labels)
Loutput <- LAUC(ROCR.simple$predictions, ROCR.simple$labels)
pinpoint(Ioutput, Loutput)
}
\references{
Ke, B. S., Chiang, A. J., & Chang, Y. C. I. (2018). Influence Analysis for the Area Under the Receiver Operating Characteristic Curve. Journal of biopharmaceutical statistics, 28(4), 722-734.
}
\seealso{
\link{IAUC} \link{LAUC}
}
