% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{bru_model_mapper_methods}
\alias{bru_model_mapper_methods}
\alias{ibm_linear.bru_model}
\alias{ibm_linear.bru_comp_list}
\alias{ibm_linear.bru_comp}
\alias{ibm_simplify.bru_model}
\alias{ibm_simplify.bru_comp}
\alias{ibm_simplify.bru_comp_list}
\title{Mapper methods for model objects}
\usage{
\method{ibm_linear}{bru_model}(mapper, input, state = NULL, ...)

\method{ibm_linear}{bru_comp_list}(mapper, input, state = NULL, ...)

\method{ibm_linear}{bru_comp}(mapper, input, state = NULL, ...)

\method{ibm_simplify}{bru_model}(mapper, input = NULL, state = NULL, ...)

\method{ibm_simplify}{bru_comp}(mapper, input = NULL, state = NULL, ...)

\method{ibm_simplify}{bru_comp_list}(mapper, input = NULL, state = NULL, ...)
}
\arguments{
\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{...}{Arguments passed on to other methods}
}
\description{
Methods for the \code{ibm_linear()} and \code{ibm_simplify()} methods for
\link{bru} model objects and related classes.
}
\section{Functions}{
\itemize{
\item \code{ibm_linear(bru_model)}: Returns a list (one element per
observation model) of \link{bm_list} objects, each with one \link{bm_taylor}
entry for each included component.

\item \code{ibm_simplify(bru_model)}: Returns a list (one element per
observation model) of \link{bm_list} objects, each with one \link{bru_mapper}
entry for each included component.

}}
