% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_replace.R
\name{in_replace}
\alias{in_replace}
\alias{\%in{}\%<-}
\alias{\%out{}\%<-}
\alias{\%in[]\%<-}
\alias{\%out[]\%<-}
\alias{\%in()\%<-}
\alias{\%out()\%<-}
\alias{\%in(]\%<-}
\alias{\%out(]\%<-}
\alias{\%in[)\%<-}
\alias{\%out[)\%<-}
\alias{\%in~\%<-}
\alias{\%out~\%<-}
\alias{\%in~f\%<-}
\alias{\%out~f\%<-}
\alias{\%in~p\%<-}
\alias{\%out~p\%<-}
\alias{\%in\%<-}
\alias{\%out\%<-}
\alias{\%in#\%<-}
\alias{\%out#\%<-}
\title{Replacing Values and Intervals}
\usage{
x \%in{}\% table <- value

x \%out{}\% table <- value

x \%in[]\% interval <- value

x \%out[]\% interval <- value

x \%in()\% interval <- value

x \%out()\% interval <- value

x \%in(]\% interval <- value

x \%out(]\% interval <- value

x \%in[)\% interval <- value

x \%out[)\% interval <- value

x \%in~\% pattern <- value

x \%out~\% pattern <- value

x \%in~f\% pattern <- value

x \%out~f\% pattern <- value

x \%in~p\% pattern <- value

x \%out~p\% pattern <- value

x \%in\% table <- value

x \%out\% table <- value

x \%in#\% count <- value

x \%out#\% count <- value
}
\arguments{
\item{x}{vector or array of values to be matched.}

\item{table}{vector or list to be matched against.}

\item{value}{replacement value.}

\item{interval}{numeric vector defining a range to be matched against.}

\item{pattern}{pattern to be matched against.}

\item{count}{numeric vector defining counts for count-based selection.}
}
\value{
\code{x} with specified values replaced with \code{value}.
}
\description{
Operators for replacing values within a given interval or set.
}
\details{
For each \code{\%*\%<-} operator of this package \code{x \%*\% y <- value} is a shorthand for
\code{x[x \%*\% y] <- value}.
}
\examples{
# interval replacement operators
x <- 1:10
x \%in[]\% c(3,7) <- 0
x

x <- 1:10
x \%in[)\% c(3,7) <- NA
x

x <- 1:10
x \%out[)\% c(3,7) <- x
x

# regular expression replacement operators
region <- as.character(state.region)
table(region)
region \%in~\% "^North" <- "North"
table(region)

# count based replacement operators
carb <- mtcars$carb
table(carb, useNA="always")
carb \%in#\% 1 <- NA
table(carb, useNA="always")

}
\seealso{
\code{\%in{}\%}
}
