% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_icm.R
\name{theme_icm}
\alias{theme_icm}
\title{Custom ggplot2 Theme for \code{intervalpsych}}
\usage{
theme_icm(hide_axis_text_y = FALSE, base_size = 12)
}
\arguments{
\item{hide_axis_text_y}{Logical. If TRUE, the y-axis text and ticks will be hidden. Default is FALSE.}

\item{base_size}{Numeric. Base font size for the theme. Default is 12.}
}
\value{
A ggplot2 theme object.
}
\description{
Creates a custom ggplot2 theme for \code{intervalpsych} visualizations.
}
\examples{
# Create sample interval data
df_intervals <- data.frame(
  lower = c(0.1, 0.3, 0.2, 0.4),
  upper = c(0.5, 0.7, 0.6, 0.8)
)
item_labels <- c("Item A", "Item B", "Item C", "Item D")

# Basic usage
plot_intervals(df_intervals, item_labels) +
  theme_icm()

# Hide y-axis text
plot_intervals(df_intervals, item_labels) +
  theme_icm(hide_axis_text_y = TRUE)

# Custom base size
plot_intervals(df_intervals, item_labels) +
  theme_icm(base_size = 14)

}
